/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.yx.conf.AppInfo;
import org.yx.db.sql.AbstractSqlBuilder;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.ItemJoiner;
import org.yx.db.sql.MapedSql;
import org.yx.db.sql.PojoMeta;
import org.yx.db.sql.SoftDeleteMeta;
import org.yx.db.visit.SumkDbVisitor;
import org.yx.exception.SumkException;
import org.yx.util.Assert;
import org.yx.util.CollectionUtils;
import org.yx.util.StringUtils;

public class SelectBuilder
extends AbstractSqlBuilder<List<Map<String, Object>>> {
    protected static String[] COMPARES = new String[]{">", ">=", "<", "<="};
    List<String> selectColumns;
    protected Map<String, Object>[] _compare;
    List<Order> orderby;
    int offset;
    int limit;
    boolean fromCache;
    boolean toCache;
    private MapedSql ms;
    protected boolean allowEmptyWhere;
    protected boolean failIfPropertyNotMapped = FAIL_IF_PROPERTY_NOT_MAPPED;

    public SelectBuilder(SumkDbVisitor<List<Map<String, Object>>> visitor) {
        super(visitor);
        this.fromCache = !"false".equalsIgnoreCase(AppInfo.get("sumk.sql.fromCache"));
        this.toCache = !"false".equalsIgnoreCase(AppInfo.get("sumk.sql.toCache"));
        this.withnull = false;
    }

    @Override
    public MapedSql toMapedSql() throws Exception {
        CharSequence order;
        this.ms = new MapedSql();
        this.pojoMeta = this.getPojoMeta();
        Assert.notNull(this.pojoMeta, "pojo meta cannot be null");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(this.buildField()).append(" FROM ").append(this.pojoMeta.getTableName());
        CharSequence where = this.buildWhere();
        if (StringUtils.isEmpty(where) && !this.allowEmptyWhere) {
            SumkException.throwException(63254325, "empty where");
        }
        if (StringUtils.isNotEmpty(where)) {
            sql.append(" WHERE ").append(where);
        }
        if (StringUtils.isNotEmpty(order = this.buildOrder())) {
            sql.append(" ORDER BY ").append(order);
        }
        if (this.offset >= 0 && this.limit > 0) {
            sql.append(" LIMIT ").append(this.offset).append(',').append(this.limit);
        }
        this.ms.sql = sql.toString();
        return this.ms;
    }

    protected CharSequence buildOrder() {
        if (CollectionUtils.isEmpty(this.orderby)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Order order : this.orderby) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(order.toString(this.pojoMeta));
        }
        return sb;
    }

    protected CharSequence buildField() {
        if (this.selectColumns != null && this.selectColumns.size() > 0) {
            return String.join((CharSequence)",", this.selectColumns.toArray(new String[this.selectColumns.size()]));
        }
        StringJoiner sj = new StringJoiner(",");
        for (ColumnMeta cm : this.pojoMeta.fieldMetas) {
            sj.add(cm.getDbColumn());
        }
        return sj.toString();
    }

    protected CharSequence buildWhere() {
        ItemJoiner joiner = new ItemJoiner(" AND ", "", "");
        joiner.addNotEmptyItem(this.buildValid()).addNotEmptyItem(this.buildIn()).addNotEmptyItem(this.buildCompare());
        return joiner.toCharSequence();
    }

    private CharSequence buildValid() {
        SoftDeleteMeta sm = this.pojoMeta.softDelete;
        if (sm == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sm.columnName).append(" =? ");
        this.ms.addParam(sm.validValue);
        return sb;
    }

    private CharSequence buildCompare() {
        if (this._compare == null) {
            return null;
        }
        ItemJoiner joiner = ItemJoiner.create();
        for (int i = 0; i < COMPARES.length && i < this._compare.length; ++i) {
            Map<String, Object> map = this._compare[i];
            CharSequence sub = this.parseMap(map, COMPARES[i]);
            if (sub == null) continue;
            joiner.item().append(sub);
        }
        return joiner.toCharSequence();
    }

    private CharSequence buildIn() {
        if (this.in == null || this.in.isEmpty()) {
            return null;
        }
        ItemJoiner joiner = ItemJoiner.create(" OR ");
        List list = this.in;
        for (Map map : list) {
            CharSequence sub = this.parseEqual(map);
            if (sub == null) continue;
            joiner.item().append(sub);
        }
        return joiner.toCharSequence();
    }

    private CharSequence parseMap(Map<String, Object> src, String compare) {
        if (CollectionUtils.isEmpty(src)) {
            return null;
        }
        ItemJoiner joiner = ItemJoiner.create();
        src.forEach((filedName, v) -> {
            ColumnMeta cm = this.pojoMeta.getByFieldName((String)filedName);
            if (v == null) {
                return;
            }
            if (cm == null) {
                if (this.failIfPropertyNotMapped) {
                    SumkException.throwException(234, filedName + " has no mapper");
                }
                return;
            }
            joiner.item().append(cm.getDbColumn()).append(compare).append(" ? ");
            this.ms.addParam(v);
        });
        return joiner.toCharSequence();
    }

    private CharSequence parseEqual(Map<String, Object> src) {
        if (CollectionUtils.isEmpty(src)) {
            return null;
        }
        ItemJoiner joiner = ItemJoiner.create();
        src.forEach((filedName, v) -> {
            if (v == null && !this.withnull) {
                return;
            }
            ColumnMeta cm = this.pojoMeta.getByFieldName((String)filedName);
            if (cm == null) {
                if (this.failIfPropertyNotMapped) {
                    SumkException.throwException(234, filedName + " has no mapper");
                }
                return;
            }
            if (v == null) {
                joiner.item().append(cm.getDbColumn()).append(" IS NULL ");
                return;
            }
            joiner.item().append(cm.getDbColumn()).append(" = ? ");
            this.ms.addParam(v);
        });
        return joiner.toCharSequence();
    }

    protected static class Order {
        String name;
        boolean desc;

        protected Order() {
        }

        public String toString(PojoMeta pm) {
            String dbName;
            ColumnMeta cm = pm.getByFieldName(this.name);
            String string = dbName = cm == null ? this.name : cm.getDbColumn();
            if (this.desc) {
                return dbName + " desc";
            }
            return dbName;
        }
    }
}

