/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.util.HashMap;
import org.yx.db.event.DeleteEvent;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.Delete;
import org.yx.db.sql.MapedSql;
import org.yx.db.sql.PojoMeta;
import org.yx.db.sql.SoftDeleteMeta;
import org.yx.db.sql.SqlBuilder;
import org.yx.exception.SumkException;

class SoftDelete
implements SqlBuilder {
    private Delete delete;

    public SoftDelete(Delete delete) {
        this.delete = delete;
    }

    @Override
    public MapedSql toMapedSql() throws InstantiationException, IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object pojo = this.delete.in.get(0);
        PojoMeta pm = this.delete.getPojoMeta();
        MapedSql ms = new MapedSql();
        StringBuilder sb = new StringBuilder();
        SoftDeleteMeta sm = pm.softDelete;
        if (sm == null) {
            SumkException.throwException(235435, pm.getTableName() + " can not be soft delete");
        }
        sb.append("UPDATE ").append(pm.getTableName()).append(" SET ").append(sm.columnName).append(" =? ");
        ms.addParam(pm.softDelete.inValidValue);
        StringBuilder where = new StringBuilder();
        for (ColumnMeta fm : pm.fieldMetas) {
            Object value = fm.value(pojo);
            if (value == null) continue;
            if (where.length() > 0) {
                where.append(" and ");
            }
            where.append(fm.getDbColumn()).append("=?");
            ms.addParam(value);
            map.put(fm.getFieldName(), value);
        }
        sb.append(" WHERE ").append(where.toString());
        ms.sql = sb.toString();
        ms.event = new DeleteEvent(pm.getTableName(), map);
        return ms;
    }
}

