/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.yx.conf.AppInfo;
import org.yx.db.annotation.ColumnType;
import org.yx.db.event.UpdateEvent;
import org.yx.db.sql.AbstractSqlBuilder;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.ItemJoiner;
import org.yx.db.sql.MapedSql;
import org.yx.db.visit.SumkDbVisitor;
import org.yx.exception.SumkException;

public class Update
extends AbstractSqlBuilder<Integer> {
    protected ColumnType _byType;
    protected Object _where;
    protected boolean _updateDBID = true;

    public Update updateDBID(boolean update) {
        this._updateDBID = update;
        return this;
    }

    public Update where(Object where) {
        this._where = where;
        return this;
    }

    public int execute() {
        return (Integer)this.accept(this.visitor);
    }

    public Update(SumkDbVisitor<Integer> visitor) {
        super(visitor);
    }

    public Update fullUpdate() {
        this.withnull = true;
        return this;
    }

    protected ColumnType byType() {
        if (this._byType != null) {
            return this._byType;
        }
        return AppInfo.modifyByColumnType;
    }

    public Update byDBID() {
        this._byType = ColumnType.ID_DB;
        return this;
    }

    public Update byCacheID() {
        this._byType = ColumnType.ID_CACHE;
        return this;
    }

    public Update update(Object pojo) {
        this._addIn(pojo);
        return this;
    }

    public Update tableClass(Class<?> tableClass) {
        this.tableClass = tableClass;
        return this;
    }

    @Override
    public MapedSql toMapedSql() throws Exception {
        CharSequence whereStr;
        this.checkIn();
        Map pojo = (Map)this.in.get(0);
        this.pojoMeta = this.getPojoMeta();
        MapedSql ms = new MapedSql();
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(this.pojoMeta.getTableName());
        ColumnMeta[] fms = this.pojoMeta.fieldMetas;
        ItemJoiner whereItem = new ItemJoiner(" AND ", "", "");
        ColumnType byType = this.byType();
        boolean notFirst = false;
        ArrayList<Object> whereParams = new ArrayList<Object>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Map<String, Object> where = null;
        boolean updateDBID = this._updateDBID;
        if (updateDBID) {
            boolean bl = updateDBID = this._where != null;
        }
        if (this._where != null) {
            where = this.pojoMeta.populate(this._where, false);
        }
        for (ColumnMeta fm : fms) {
            Object value = null;
            if (where != null) {
                if (where.containsKey(fm.getFieldName())) {
                    value = where.remove(fm.getFieldName());
                    whereItem.item().append(fm.getDbColumn()).append(" =? ");
                    whereParams.add(value);
                    paramMap.put(fm.getFieldName(), value);
                }
            } else if (fm.accept(byType)) {
                value = fm.value(pojo);
                if (value == null) {
                    SumkException.throwException(234, fm.getFieldName() + " cannot be null");
                }
                whereItem.item().append(fm.getDbColumn()).append(" =? ");
                whereParams.add(value);
                paramMap.put(fm.getFieldName(), value);
                continue;
            }
            if ((value = fm.value(pojo)) == null && !this.withnull || fm.accept(ColumnType.ID_DB) && !updateDBID) continue;
            sb.append(notFirst ? " , " : " SET ");
            notFirst = true;
            sb.append(fm.getDbColumn()).append(" =? ");
            ms.addParam(value);
        }
        if (FAIL_IF_PROPERTY_NOT_MAPPED && where != null && where.size() > 0) {
            SumkException.throwException(234234, where.keySet() + " is not valid filed name");
        }
        if ((whereStr = whereItem.toCharSequence()) == null || whereStr.length() == 0) {
            SumkException.throwException(345445, "where cannot be null");
        }
        sb.append(" WHERE ").append(whereStr);
        ms.addParams(whereParams);
        ms.sql = sb.toString();
        UpdateEvent event = new UpdateEvent(this.pojoMeta.getTableName(), this.pojoMeta.populate(pojo, false), paramMap, this.withnull);
        ms.event = event;
        return ms;
    }
}

