/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.visit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yx.db.sql.PojoMeta;
import org.yx.log.Log;
import org.yx.redis.RecordReq;
import org.yx.redis.RedisPool;

public class Exchange {
    private List<Map<String, Object>> leftIn;
    private List<String> data;
    private List<Map<String, Object>> canToRedis;

    public Exchange(List<Map<String, Object>> leftIn) {
        this.leftIn = leftIn;
    }

    public List<Map<String, Object>> getLeftIn() {
        return this.leftIn;
    }

    public List<String> getData() {
        return this.data;
    }

    public List<Map<String, Object>> getCanToRedis() {
        return this.canToRedis;
    }

    public void findFromCache(PojoMeta pm) {
        List<Map<String, Object>> origin = this.leftIn;
        if (origin == null || origin.isEmpty() || RedisPool.defaultRedis() == null) {
            return;
        }
        try {
            boolean[] onlyRedis = new boolean[origin.size()];
            ArrayList<String> redisList = new ArrayList<String>();
            for (int i = 0; i < onlyRedis.length; ++i) {
                Map<String, Object> map = origin.get(i);
                if (!pm.isOnlyRedisID(map)) continue;
                redisList.add(pm.getRedisID(map, false));
                onlyRedis[i] = true;
            }
            List<String> fromRedis = RecordReq.getMultiValue(pm, redisList);
            if (fromRedis == null || fromRedis.isEmpty()) {
                return;
            }
            this.leftIn = new ArrayList<Map<String, Object>>();
            int k = 0;
            this.data = new ArrayList<String>();
            for (int i = 0; i < onlyRedis.length; ++i) {
                Map<String, Object> conditon = origin.get(i);
                if (!onlyRedis[i]) {
                    this.leftIn.add(conditon);
                    continue;
                }
                String value = fromRedis.get(k);
                ++k;
                if (value != null && value.length() > 0) {
                    this.data.add(value);
                    continue;
                }
                if (this.canToRedis == null) {
                    this.canToRedis = new ArrayList<Map<String, Object>>();
                }
                this.canToRedis.add(conditon);
                this.leftIn.add(conditon);
            }
        }
        catch (Exception e) {
            this.leftIn = origin;
            this.data = null;
            this.canToRedis = null;
            Log.printStack("sumk.sql", e);
        }
    }
}

