/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.visit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yx.db.annotation.CacheType;
import org.yx.db.sql.PojoMeta;
import org.yx.db.visit.ResultHandler;
import org.yx.util.CollectionUtils;
import org.yx.util.GsonUtil;
import org.yx.util.StringUtils;

public class MapResultHandler
implements ResultHandler {
    public static MapResultHandler handler = new MapResultHandler();

    private MapResultHandler() {
    }

    @Override
    public <T> List<T> parseFromJson(PojoMeta pm, List<String> jsons) throws InstantiationException, IllegalAccessException {
        if (CollectionUtils.isEmpty(jsons)) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String json : jsons) {
            Map<String, Object> map;
            if (StringUtils.isEmpty(json)) continue;
            if (pm.cacheType() == CacheType.LIST || json.startsWith("[") && json.endsWith("]")) {
                Object[] ts = (Object[])GsonUtil.fromJson(json, pm.pojoArrayClz());
                if (ts == null || ts.length == 0) continue;
                for (Object obj : ts) {
                    Map<String, Object> map2 = pm.populate(obj, false);
                    if (map2.size() <= 0) continue;
                    list.add(map2);
                }
                continue;
            }
            Object obj = GsonUtil.fromJson(json, pm.pojoClz);
            if (obj == null || (map = pm.populate(obj, false)).size() <= 0) continue;
            list.add(map);
        }
        return list;
    }

    @Override
    public <T> List<T> parse(PojoMeta pm, List<Map<String, Object>> list) {
        return list;
    }
}

