/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.visit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.yx.db.annotation.CacheType;
import org.yx.db.sql.PojoMeta;
import org.yx.db.visit.ResultHandler;
import org.yx.util.CollectionUtils;
import org.yx.util.GsonUtil;
import org.yx.util.StringUtils;

public class PojoResultHandler
implements ResultHandler {
    public static PojoResultHandler handler = new PojoResultHandler();

    @Override
    public <T> List<T> parseFromJson(PojoMeta pm, List<String> jsons) throws InstantiationException, IllegalAccessException {
        if (CollectionUtils.isEmpty(jsons)) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String json : jsons) {
            if (StringUtils.isEmpty(json)) continue;
            if (pm.cacheType() == CacheType.LIST || json.startsWith("[") && json.endsWith("]")) {
                Object[] ts = (Object[])GsonUtil.fromJson(json, pm.pojoArrayClz());
                if (ts == null || ts.length == 0) continue;
                list.addAll(Arrays.asList(ts));
                continue;
            }
            Object obj = GsonUtil.fromJson(json, pm.pojoClz);
            if (obj == null) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public <T> List<T> parse(PojoMeta pm, List<Map<String, Object>> list) throws Exception {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Map<String, Object> map : list) {
            if (map.isEmpty()) continue;
            ret.add(pm.buildPojo(map));
        }
        return ret;
    }
}

