/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.visit;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.PojoMeta;
import org.yx.util.Assert;

public class ResultSetUtils {
    public static List<Map<String, Object>> toMapList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(5);
        if (rs == null) {
            return list;
        }
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        while (rs.next()) {
            rowData = new HashMap(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                rowData.put(md.getColumnName(i), rs.getObject(i));
            }
            list.add(rowData);
        }
        return list;
    }

    public static List<Map<String, Object>> toMapList(ResultSet rs, PojoMeta pm) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        if (rs == null) {
            return list;
        }
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        while (rs.next()) {
            rowData = new HashMap(columnCount * 2);
            for (int i = 1; i <= columnCount; ++i) {
                if (pm == null) {
                    rowData.put(md.getColumnName(i).toLowerCase(), rs.getObject(i));
                    continue;
                }
                ColumnMeta cm = pm.getByColumnDBName(md.getColumnName(i));
                Assert.notNull(cm, md.getColumnName(i) + " has no mapper");
                rowData.put(cm.getFieldName(), rs.getObject(i));
            }
            list.add(rowData);
        }
        rs.close();
        return list;
    }

    public static List toList(ResultSet rs) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>(10);
        if (rs == null) {
            return list;
        }
        ResultSetMetaData md = rs.getMetaData();
        Assert.isTrue(md.getColumnCount() == 1, "result data column is " + md.getColumnCount() + ", not 1");
        while (rs.next()) {
            list.add(rs.getObject(1));
        }
        rs.close();
        return list;
    }
}

