/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.visit;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.yx.db.DBType;
import org.yx.db.conn.ConnectionPool;
import org.yx.db.conn.EventLane;
import org.yx.db.sql.MapedSql;
import org.yx.db.sql.PojoMeta;
import org.yx.db.sql.SelectBuilder;
import org.yx.db.visit.ResultSetUtils;
import org.yx.db.visit.SumkDbVisitor;
import org.yx.log.ConsoleLog;
import org.yx.log.Log;

public class Visitors {
    public static final SumkDbVisitor<Integer> modifyVisitor = builder -> {
        MapedSql maped = builder.toMapedSql();
        if (ConsoleLog.isEnable((byte)100)) {
            Log.get("sumk.SQL.visitor").trace(String.valueOf(maped));
        }
        Connection conn = ConnectionPool.get().connection(DBType.WRITE);
        PreparedStatement statement = conn.prepareStatement(maped.getSql());
        List<Object> params = maped.getParamters();
        if (params != null && params.size() > 0) {
            for (int i = 0; i < params.size(); ++i) {
                statement.setObject(i + 1, params.get(i));
            }
        }
        Log.get("sumk.SQL").debug(" <== {}", (Object)statement);
        int ret = statement.executeUpdate();
        statement.close();
        EventLane.pubuish(conn, maped.getEvent());
        return ret;
    };
    public static final SumkDbVisitor<List<Map<String, Object>>> queryVisitor = builder -> {
        MapedSql maped = builder.toMapedSql();
        if (ConsoleLog.isEnable((byte)100)) {
            Log.get("sumk.SQL.visitor").trace(String.valueOf(maped));
        }
        Connection conn = ConnectionPool.get().connection(DBType.ANY);
        PreparedStatement statement = conn.prepareStatement(maped.getSql());
        List<Object> params = maped.getParamters();
        if (params != null && params.size() > 0) {
            for (int i = 0; i < params.size(); ++i) {
                statement.setObject(i + 1, params.get(i));
            }
        }
        Log.get("sumk.SQL").debug(" ==> {}", (Object)statement);
        ResultSet ret = statement.executeQuery();
        PojoMeta pm = null;
        if (SelectBuilder.class.isInstance(builder)) {
            pm = ((SelectBuilder)builder).getPojoMeta();
        }
        List<Map<String, Object>> list = ResultSetUtils.toMapList(ret, pm);
        statement.close();
        return list;
    };
    public static final SumkDbVisitor<List<?>> singleListQueryVisitor = builder -> {
        MapedSql maped = builder.toMapedSql();
        if (ConsoleLog.isEnable((byte)100)) {
            Log.get("sumk.SQL.single.visitor").trace(String.valueOf(maped));
        }
        Connection conn = ConnectionPool.get().connection(DBType.ANY);
        PreparedStatement statement = conn.prepareStatement(maped.getSql());
        List<Object> params = maped.getParamters();
        if (params != null && params.size() > 0) {
            for (int i = 0; i < params.size(); ++i) {
                statement.setObject(i + 1, params.get(i));
            }
        }
        Log.get("sumk.SQL.single").debug(" ==> {}", (Object)statement);
        ResultSet ret = statement.executeQuery();
        List list = ResultSetUtils.toList(ret);
        statement.close();
        return list;
    };
}

