/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.yx.common.ThreadContext;
import org.yx.conf.AppInfo;
import org.yx.exception.BizException;
import org.yx.http.HttpHolder;
import org.yx.http.HttpUtil;
import org.yx.http.handler.HttpInfo;
import org.yx.log.Log;

public abstract class AbstractHttpServer
extends HttpServlet {
    private static final long serialVersionUID = 74378082364534491L;
    private static boolean PATH_CHECK;

    private boolean validPath(Class<?> actionClz, String path) {
        String pname = actionClz.getName();
        String[] names = pname.split("\\.");
        for (int i = 2; i < names.length; ++i) {
            if (!names[i].equals(path)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.setRespHeader(req, resp);
            String act = req.getParameter("act");
            String path = req.getPathInfo();
            Log.get(((Object)((Object)this)).getClass()).trace("{}?act={}", (Object)path, (Object)act);
            if (PATH_CHECK) {
                int index;
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((index = path.lastIndexOf("/")) < 0) {
                    Log.get(((Object)((Object)this)).getClass()).error(path + " path error");
                    HttpUtil.error(resp, -1001, "\u8bf7\u6c42\u683c\u5f0f\u4e0d\u6b63\u786e", HttpUtil.charset(req));
                    return;
                }
                path = path.substring(index + 1);
            }
            if (act == null) {
                Log.get(((Object)((Object)this)).getClass()).error("act is empty");
                HttpUtil.error(resp, -1002, "\u8bf7\u6c42\u683c\u5f0f\u4e0d\u6b63\u786e", HttpUtil.charset(req));
                return;
            }
            HttpInfo info = HttpHolder.getHttpInfo(act);
            if (info == null) {
                Log.get(((Object)((Object)this)).getClass()).error(act + " donot found handler");
                HttpUtil.error(resp, -1003, "\u8bf7\u6c42\u683c\u5f0f\u4e0d\u6b63\u786e", HttpUtil.charset(req));
                return;
            }
            if (PATH_CHECK && !this.validPath(info.getObj().getClass(), path)) {
                Log.get(((Object)((Object)this)).getClass()).error(act + " in error package");
                HttpUtil.error(resp, -1004, "\u8bf7\u6c42\u7684\u6a21\u5757\u4e0d\u6b63\u786e", HttpUtil.charset(req));
                return;
            }
            ThreadContext.httpContext(act);
            this.handle(act, info, req, resp);
        }
        catch (Exception e) {
            if (BizException.class.isInstance(e)) {
                Log.get("sumk.http").info("code:{},message:{}", (Object)((BizException)BizException.class.cast(e)).getCode(), (Object)e.getMessage());
            } else {
                Log.printStack(e);
            }
            try {
                HttpUtil.error(resp, -1005, "\u8bf7\u6c42\u683c\u5f0f\u4e0d\u6b63\u786e", HttpUtil.charset(req));
            }
            catch (IOException e1) {
                Log.printStack(e);
            }
        }
        finally {
            ThreadContext.remove();
        }
    }

    protected void setRespHeader(HttpServletRequest req, HttpServletResponse resp) {
        resp.setContentType("application/json;charset=" + HttpUtil.charset(req));
    }

    protected abstract void handle(String var1, HttpInfo var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    static {
        AppInfo.addObserver((a, b) -> {
            PATH_CHECK = AppInfo.getBoolean("http.path.check", false);
        });
    }
}

