/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yx.bean.Bean;
import org.yx.bean.Plugin;
import org.yx.conf.AppInfo;
import org.yx.http.HttpHolder;
import org.yx.http.Web;
import org.yx.log.Log;
import org.yx.util.GsonUtil;
import org.yx.util.StringUtils;
import org.yx.validate.Param;
import org.yx.validate.ParamInfo;

@Bean
public class HttpInfoWatcher
implements Plugin {
    @Override
    public void start() {
        if (!AppInfo.getBoolean("sumk.http.print.actions", false)) {
            return;
        }
        Log.get("sumk.http").info("\n{}\n", (Object)GsonUtil.gsonBuilder("httpinfo").create().toJson(HttpInfoWatcher.infos()));
    }

    @Override
    public void stop() {
    }

    public static List<Map<String, Object>> infos() {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(HttpHolder.actMap.size());
        HttpHolder.actMap.forEach((name, http) -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            ret.add(map);
            map.put("name", name);
            if (http.getAction() != null) {
                Web web = http.getAction();
                map.put("requireLogin", web.requireLogin());
                map.put("requestEncrypt", (Object)web.requestEncrypt());
                map.put("responseEncrypt", (Object)web.responseEncrypt());
                map.put("sign", web.sign());
                map.put("description", web.description());
            }
            map.put("upload", http.getUpload() != null);
            ArrayList list = new ArrayList();
            int paramSize = http.getArgNames() == null ? 0 : http.getArgNames().length;
            for (int i = 0; i < paramSize; ++i) {
                LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
                list.add(param);
                param.put("name", http.getArgNames()[i]);
                param.put("type", http.getArgTypes()[i].getName());
                ParamInfo pi = http.getParamInfos()[i];
                if (pi == null) continue;
                Param p = pi.getParam();
                if (StringUtils.isNotEmpty(p.cnName())) {
                    param.put("cnName", p.cnName());
                }
                param.put("required", p.required());
                if (p.length() > -1) {
                    param.put("length", p.length());
                }
                if (p.maxLength() > -1) {
                    param.put("maxLength", p.maxLength());
                }
                if (p.minLength() <= -1) continue;
                param.put("minLength", p.minLength());
            }
            map.put("params", list);
            map.put("result", HttpInfoWatcher.descript(http.getM().getReturnType()));
        });
        return ret;
    }

    private static Map<String, String> descript(Class<?> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Class<?> tempClz = clazz; tempClz != null && !tempClz.getName().startsWith("java."); tempClz = tempClz.getSuperclass()) {
            Field[] fs;
            for (Field f : fs = tempClz.getDeclaredFields()) {
                map.putIfAbsent(f.getName(), f.getType().getSimpleName());
            }
        }
        return map;
    }
}

