/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.yx.conf.AppInfo;
import org.yx.exception.HttpException;
import org.yx.http.ErrorResp;
import org.yx.http.handler.ReqBodyHandler;
import org.yx.log.Log;
import org.yx.util.GsonUtil;
import org.yx.util.StringUtils;

public final class HttpUtil {
    static final int MAXLENGTH = 0x6400000;
    public static Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static Charset charset(HttpServletRequest req) {
        String charsetName = AppInfo.get("http.charset");
        if (StringUtils.isEmpty(charsetName)) {
            charsetName = req.getCharacterEncoding();
        }
        if (StringUtils.isEmpty(charsetName) || charsetName.equalsIgnoreCase(DEFAULT_CHARSET.name())) {
            return DEFAULT_CHARSET;
        }
        if (!Charset.isSupported(charsetName)) {
            Log.get("sumk.http").error("charset '{}' is not supported", (Object)charsetName);
            return DEFAULT_CHARSET;
        }
        return Charset.forName(charsetName);
    }

    public static void error(HttpServletResponse resp, int code, String errorMsg, Charset charset) throws UnsupportedEncodingException, IOException {
        resp.setStatus(499);
        ErrorResp r = new ErrorResp();
        r.setCode(code);
        r.setMessage(errorMsg);
        resp.getOutputStream().write(GsonUtil.toJson(r).getBytes(charset));
    }

    public static byte[] extractData(byte[] bs) {
        if (bs != null && bs.length > 4 && bs[0] == 100 && bs[1] == 97 && bs[2] == 116 && bs[3] == 97 && bs[4] == 61) {
            byte[] temp = new byte[bs.length - 5];
            System.arraycopy(bs, 5, temp, 0, temp.length);
            return temp;
        }
        return bs;
    }

    public static byte[] extractData(InputStream in) throws IOException {
        int count = 0;
        int n = 0;
        byte[] temp = new byte[4096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while (-1 != (n = in.read(temp))) {
            output.write(temp, 0, n);
            if ((count += n) <= 0x6400000) continue;
            HttpException.throwException(ReqBodyHandler.class, "request body is too long");
        }
        byte[] bs = output.toByteArray();
        output.close();
        return HttpUtil.extractData(bs);
    }
}

