/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.yx.http.HttpUtil;
import org.yx.http.filter.LocalUserSession;
import org.yx.http.filter.LoginObject;
import org.yx.http.filter.LoginServlet;
import org.yx.http.filter.RemoteUserSession;
import org.yx.http.filter.Session;
import org.yx.http.filter.UserSession;
import org.yx.log.Log;
import org.yx.redis.Redis;
import org.yx.redis.RedisPool;
import org.yx.util.UUIDSeed;
import org.yx.util.secury.Base64Util;

public abstract class AbstractSessionFilter
implements LoginServlet {
    private UserSession session;

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String user = req.getParameter(this.userName());
        String sid = this.createToken();
        try {
            LoginObject obj = this.login(sid, user, req);
            Charset charset = HttpUtil.charset(req);
            if (obj == null) {
                Log.get("loginAction").info(user + ":login Object must not be null");
                HttpUtil.error(resp, 1001, "login failed", charset);
                return;
            }
            if (obj.getErrorMsg() != null) {
                Log.get("loginAction").debug(user + ":" + obj.getErrorMsg());
                HttpUtil.error(resp, 1001, obj.getErrorMsg(), charset);
                return;
            }
            byte[] key = this.createEncryptKey(req);
            this.session.putKey(sid, key);
            resp.setHeader(Session.SESSIONID, sid);
            this.outputKey(resp, key);
            resp.getOutputStream().write("\t\n".getBytes());
            if (obj.getJson() != null) {
                resp.getOutputStream().write(obj.getJson().getBytes(charset));
            }
        }
        catch (Exception e) {
            Log.printStack(e);
        }
    }

    protected void outputKey(HttpServletResponse resp, byte[] key) throws IOException {
        resp.getOutputStream().write(Base64Util.encode(key));
    }

    protected byte[] createEncryptKey(HttpServletRequest req) {
        byte[] key = UUIDSeed.seq().substring(4).getBytes();
        return key;
    }

    protected String userName() {
        return "username";
    }

    protected String createToken() {
        return UUIDSeed.random();
    }

    private synchronized void initSession() {
        if (this.session != null) {
            return;
        }
        Redis redis = RedisPool.getRedisExactly("session");
        UserSession userSession = this.session = redis == null ? new LocalUserSession() : new RemoteUserSession(redis);
        if (LocalUserSession.class.isInstance(this.session)) {
            Log.get("loginAction").info("use local session.");
        }
    }

    @Override
    public void init(ServletConfig config) {
        this.initSession();
    }

    @Override
    public UserSession userSession() {
        if (this.session == null) {
            this.initSession();
        }
        return this.session;
    }

    protected abstract LoginObject login(String var1, String var2, HttpServletRequest var3);
}

