/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.filter;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.yx.common.TimedObject;
import org.yx.conf.AppInfo;
import org.yx.http.HttpHeadersHolder;
import org.yx.http.filter.SessionObject;
import org.yx.http.filter.UserSession;
import org.yx.log.Log;
import org.yx.main.SumkServer;

public class LocalUserSession
implements UserSession {
    private Map<String, TimedObject> map = new ConcurrentHashMap<String, TimedObject>();
    private Map<String, byte[]> keyMap = new ConcurrentHashMap<String, byte[]>();

    @Override
    public void putKey(String sessionId, byte[] key) {
        this.keyMap.put(sessionId, key);
    }

    public LocalUserSession() {
        Log.get("session").info("use local user session");
        SumkServer.runDeamon(() -> {
            if (SumkServer.isDestoryed()) {
                return;
            }
            Set<String> set = this.map.keySet();
            long now = System.currentTimeMillis();
            for (String key : set) {
                TimedObject t = this.map.get(key);
                if (t == null || now <= t.getEvictTime()) continue;
                this.map.remove(key);
                this.keyMap.remove(key);
            }
            Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
        }, "local-session");
    }

    @Override
    public <T extends SessionObject> T getUserObject(Class<T> clz) {
        TimedObject to = this.map.get(HttpHeadersHolder.token());
        if (to == null) {
            return null;
        }
        return (T)((SessionObject)to.getTarget());
    }

    @Override
    public void flushSession() {
        TimedObject to = this.map.get(HttpHeadersHolder.token());
        if (to == null) {
            return;
        }
        to.setEvictTime(System.currentTimeMillis() + (long)(AppInfo.httpSessionTimeout * 1000));
    }

    @Override
    public void setSession(String key, SessionObject sessionObj) {
        TimedObject to = new TimedObject();
        to.setTarget(sessionObj);
        to.setEvictTime(System.currentTimeMillis() + (long)(AppInfo.httpSessionTimeout * 1000));
        this.map.put(key, to);
    }

    @Override
    public void removeSession() {
        String token = HttpHeadersHolder.token();
        if (token == null) {
            return;
        }
        this.map.remove(token);
        this.keyMap.remove(token);
    }

    @Override
    public byte[] getKey(String sid) {
        return this.keyMap.get(sid);
    }

    @Override
    public void updateSession(SessionObject sessionObj) {
        String token = HttpHeadersHolder.token();
        if (token == null) {
            return;
        }
        this.setSession(token, sessionObj);
    }
}

