/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.filter;

import org.yx.conf.AppInfo;
import org.yx.http.HttpHeadersHolder;
import org.yx.http.filter.SessionObject;
import org.yx.http.filter.UserSession;
import org.yx.redis.Redis;
import org.yx.util.GsonUtil;

public class RemoteUserSession
implements UserSession {
    private final Redis redis;
    private static final String AES_KEY = "KEY";
    private static final String SESSION_OBJECT = "OBJ";

    private String bigKey() {
        return this.bigKey(HttpHeadersHolder.token());
    }

    private String bigKey(String token) {
        if (token == null || token.isEmpty()) {
            return null;
        }
        return "S#" + token;
    }

    public RemoteUserSession(Redis redis) {
        this.redis = redis;
    }

    @Override
    public void putKey(String token, byte[] key) {
        String bigkey = this.bigKey(token);
        this.redis.hset(bigkey, AES_KEY, key);
        this.redis.expire(bigkey, AppInfo.httpSessionTimeout);
    }

    @Override
    public byte[] getKey(String sid) {
        String bigKey = this.bigKey(sid);
        if (bigKey == null) {
            return null;
        }
        return this.redis.hgetBinarry(bigKey, AES_KEY);
    }

    @Override
    public <T extends SessionObject> T getUserObject(Class<T> clz) {
        String bigKey = this.bigKey();
        if (bigKey == null) {
            return null;
        }
        String json = this.redis.hget(bigKey, SESSION_OBJECT);
        if (json == null) {
            return null;
        }
        return (T)((SessionObject)GsonUtil.fromJson(json, clz));
    }

    @Override
    public void flushSession() {
        String bigKey = this.bigKey();
        if (bigKey == null) {
            return;
        }
        this.redis.expire(bigKey, AppInfo.httpSessionTimeout);
    }

    @Override
    public void setSession(String sid, SessionObject sessionObj) {
        String bigKey = this.bigKey(sid);
        String json = GsonUtil.toJson(sessionObj);
        this.redis.hset(bigKey, SESSION_OBJECT, json);
        this.redis.expire(bigKey, AppInfo.httpSessionTimeout);
    }

    @Override
    public void removeSession() {
        String bigKey = this.bigKey();
        if (bigKey == null) {
            return;
        }
        this.redis.del(bigKey);
    }

    @Override
    public void updateSession(SessionObject sessionObj) {
        String bigKey = this.bigKey();
        if (bigKey == null) {
            return;
        }
        this.setSession(bigKey, sessionObj);
    }
}

