/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.yx.common.ActStatis;
import org.yx.exception.BizException;
import org.yx.exception.HttpException;
import org.yx.exception.InvalidParamException;
import org.yx.http.HttpUtil;
import org.yx.http.Web;
import org.yx.http.handler.HttpHandler;
import org.yx.http.handler.UploadFileHolder;
import org.yx.http.handler.WebContext;
import org.yx.log.Log;

public class HttpHandlerChain
implements HttpHandler {
    private List<HttpHandler> handlers = new ArrayList<HttpHandler>();
    public static HttpHandlerChain inst = new HttpHandlerChain();
    public static HttpHandlerChain upload = new HttpHandlerChain();
    static final ActStatis actStatic = new ActStatis();

    private HttpHandlerChain() {
    }

    public void addHandler(HttpHandler handler) {
        if (this.handlers.contains(handler)) {
            return;
        }
        this.handlers.add(handler);
    }

    public void setHandlers(List<HttpHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public boolean accept(Web web) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(WebContext ctx) throws Exception {
        long begin = System.currentTimeMillis();
        boolean success = false;
        try {
            for (int i = 0; i < this.handlers.size(); ++i) {
                HttpHandler h = this.handlers.get(i);
                if (!h.accept(ctx.getInfo().getAction())) continue;
                if (Log.isTraceEnable("handle")) {
                    if (String.class.isInstance(ctx.getData())) {
                        String s = (String)ctx.getData();
                        Log.get(this.getClass(), "handle").trace("{}:{}", (Object)h.getClass().getSimpleName(), (Object)s);
                    } else {
                        Log.get(this.getClass(), "handle").trace(h.getClass().getSimpleName());
                    }
                }
                if (!h.handle(ctx)) continue;
                success = true;
                boolean s = true;
                return s;
            }
        }
        catch (HttpException e1) {
            Log.printStack(e1);
            HttpUtil.error(ctx.getHttpResponse(), -1013243, "data format error", ctx.getCharset());
        }
        catch (BizException e2) {
            Log.get("sumk.http").info("bussiness exception,code:{},message:{}", (Object)e2.getCode(), (Object)e2.getMessage());
            HttpUtil.error(ctx.getHttpResponse(), e2.getCode(), e2.getMessage(), ctx.getCharset());
        }
        catch (InvalidParamException e3) {
            Log.get("sumk.http").info("InvalidParamException,message:{},paramName:{},arg:{}", new Object[]{e3.getMessage(), e3.getInfo().getParamName(), e3.getParam()});
            HttpUtil.error(ctx.getHttpResponse(), 1010, e3.getMessage(), ctx.getCharset());
        }
        catch (Throwable e) {
            Throwable temp = e;
            if (InvocationTargetException.class.isInstance(temp)) {
                temp = ((InvocationTargetException)temp).getTargetException();
            }
            while (temp != null) {
                if (BizException.class.isInstance(temp)) {
                    BizException be = (BizException)temp;
                    Log.get("sumk.http").info("bussiness exception,code:{},message:{}", (Object)be.getCode(), (Object)be.getMessage());
                    HttpUtil.error(ctx.getHttpResponse(), be.getCode(), be.getMessage(), ctx.getCharset());
                    boolean bl = true;
                    return bl;
                }
                temp = temp.getCause();
            }
            Log.printStack(e);
            HttpUtil.error(ctx.getHttpResponse(), -2343254, "\u8bf7\u6c42\u51fa\u9519", ctx.getCharset());
        }
        finally {
            UploadFileHolder.remove();
            actStatic.visit(ctx.getAct(), System.currentTimeMillis() - begin, success);
        }
        return true;
    }
}

