/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.handler;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.yx.exception.HttpException;
import org.yx.http.HttpUtil;
import org.yx.http.Upload;
import org.yx.http.Web;
import org.yx.http.handler.HttpHandler;
import org.yx.http.handler.UploadFile;
import org.yx.http.handler.UploadFileHolder;
import org.yx.http.handler.WebContext;
import org.yx.log.Log;

public class UploadHandler
implements HttpHandler {
    @Override
    public boolean accept(Web web) {
        return true;
    }

    @Override
    public boolean handle(WebContext ctx) throws Throwable {
        HttpServletRequest request = ctx.getHttpRequest();
        Upload uploadInfo = ctx.getInfo().getUpload();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(uploadInfo.maxSize());
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding(ctx.getCharset().name());
        List list = upload.parseRequest(request);
        if (list == null || list.isEmpty()) {
            HttpException.throwException(this.getClass(), "\u6ca1\u6709\u6587\u4ef6");
        }
        ArrayList<UploadFile> files = new ArrayList<UploadFile>(list.size());
        for (FileItem fi : list) {
            String name = fi.getName();
            if (name == null) {
                if (!"data".equals(fi.getFieldName())) continue;
                ctx.setData(HttpUtil.extractData(fi.get()));
                continue;
            }
            Log.get(this.getClass()).debug("fileupload#name:{},field:{}", (Object)name, (Object)fi.getFieldName());
            name = name.toLowerCase();
            boolean valid = false;
            for (String ext : uploadInfo.exts()) {
                if (!name.endsWith(ext)) continue;
                UploadFile item = new UploadFile();
                item.fieldName = fi.getFieldName();
                item.name = fi.getName();
                item.inputStream = fi.getInputStream();
                item.size = fi.getSize();
                files.add(item);
                valid = true;
                break;
            }
            if (valid) continue;
            HttpException.throwException(this.getClass(), name + "\u4e0d\u662f\u6709\u6548\u7684\u6587\u4ef6\u7c7b\u578b");
        }
        UploadFileHolder.setFiles(files);
        return false;
    }
}

