/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.start;

import org.yx.bean.AbstractBeanListener;
import org.yx.bean.BeanEvent;
import org.yx.bean.BeanPool;
import org.yx.bean.InnerIOC;
import org.yx.common.StartContext;
import org.yx.conf.AppInfo;
import org.yx.http.Login;
import org.yx.http.filter.LoginServlet;
import org.yx.http.start.HttpFactory;
import org.yx.http.start.ServletFactory;
import org.yx.log.Log;

public class HttpBeanListener
extends AbstractBeanListener {
    private HttpFactory factory;
    private ServletFactory servletFactory;

    public HttpBeanListener() {
        super(AppInfo.get("http"));
        if (StartContext.inst.get("nohttp") != null) {
            this.valid = false;
        }
    }

    @Override
    public void listen(BeanEvent event) {
        if (this.factory == null) {
            try {
                Class.forName("javax.servlet.http.HttpServlet");
            }
            catch (Exception e) {
                Log.get("sumk.http").error("javax-servlet-api-**.jar is not imported");
                this.valid = false;
                return;
            }
            this.factory = new HttpFactory();
            this.servletFactory = new ServletFactory();
        }
        try {
            Class<?> clz = event.clz();
            if (LoginServlet.class.isAssignableFrom(clz)) {
                Login login = clz.getAnnotation(Login.class);
                if (login != null) {
                    InnerIOC.putClass(BeanPool.getBeanName(LoginServlet.class), clz);
                    StartContext.inst.put(LoginServlet.class, (Object)login.path());
                }
                return;
            }
            this.factory.resolve(clz);
            this.servletFactory.resolve(clz);
        }
        catch (Exception e) {
            Log.printStack(e);
        }
    }
}

