/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.start;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.yx.asm.AsmUtils;
import org.yx.bean.InnerIOC;
import org.yx.common.MethodInfo;
import org.yx.http.HttpHolder;
import org.yx.http.Upload;
import org.yx.http.Web;
import org.yx.http.handler.HttpInfo;
import org.yx.http.start.HttpNameResolver;
import org.yx.log.Log;
import org.yx.validate.Param;

class HttpFactory {
    private HttpNameResolver nameResolver = new HttpNameResolver();

    HttpFactory() {
    }

    public void resolve(Class<?> clz) throws Exception {
        Method[] methods = clz.getMethods();
        ArrayList<Method> httpMethods = new ArrayList<Method>();
        for (Method m : methods) {
            if (AsmUtils.isFilted(m.getName()) || AsmUtils.notPublicOnly(m.getModifiers()) || m.getAnnotation(Web.class) == null) continue;
            httpMethods.add(m);
        }
        if (httpMethods.isEmpty()) {
            return;
        }
        Object obj = InnerIOC.putClass(null, clz);
        Class<?> proxyClz = obj.getClass();
        String classFullName = clz.getName();
        for (Method m : httpMethods) {
            Web act = m.getAnnotation(Web.class);
            Upload upload = m.getAnnotation(Upload.class);
            String soaName = this.nameResolver.solve(clz, m, act.value());
            Log.get("sumk.http").debug("http action-{}:{}", (Object)soaName, (Object)classFullName);
            if (HttpHolder.getHttpInfo(soaName) != null) {
                Log.get("sumk.http").error(soaName + " already existed");
                continue;
            }
            Method proxyedMethod = AsmUtils.proxyMethod(m, proxyClz);
            int argSize = m.getParameterTypes().length;
            if (argSize == 0) {
                HttpHolder.putActInfo(soaName, new HttpInfo(obj, proxyedMethod, null, null, null, act, upload, new Param[0]));
                continue;
            }
            Annotation[][] paramAnno = m.getParameterAnnotations();
            Param[] params = new Param[paramAnno.length];
            block2: for (int i = 0; i < paramAnno.length; ++i) {
                Annotation[] a;
                for (Annotation a2 : a = paramAnno[i]) {
                    if (Param.class != a2.annotationType()) continue;
                    params[i] = (Param)a2;
                    continue block2;
                }
            }
            MethodInfo mInfo = AsmUtils.createMethodInfo(classFullName, m);
            Class<?> argClz = AsmUtils.CreateArgPojo(classFullName, mInfo);
            HttpHolder.putActInfo(soaName, new HttpInfo(obj, proxyedMethod, argClz, mInfo.getArgNames(), m.getParameterTypes(), act, upload, params));
        }
    }
}

