/*
 * Decompiled with CFR 0.152.
 */
package org.yx.http.start;

import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.yx.bean.IOC;
import org.yx.bean.Plugin;
import org.yx.conf.AppInfo;
import org.yx.log.Log;
import org.yx.main.SumkLoaderListener;
import org.yx.util.CollectionUtils;
import org.yx.util.StringUtils;

public class JettyServer
implements Plugin {
    private final int port;
    private Server server;
    private boolean started = false;

    public JettyServer(int port) {
        this.port = port;
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        try {
            QueuedThreadPool pool = new QueuedThreadPool(AppInfo.getInt("http.pool.maxThreads", 200), AppInfo.getInt("http.pool.minThreads", 8), AppInfo.getInt("http.pool.idleTimeout", 60000), new LinkedBlockingDeque(AppInfo.getInt("http.pool.queues", 1000)));
            this.server = new Server((ThreadPool)pool);
            ServerConnector connector = new ServerConnector(this.server, null, null, null, AppInfo.getInt("http.connector.acceptors", 0), AppInfo.getInt("http.connector.selectors", 5), new ConnectionFactory[]{new HttpConnectionFactory()});
            Log.get("HttpServer").info("listen port\uff1a" + this.port);
            String host = AppInfo.get("http.host");
            if (host != null && host.length() > 0) {
                connector.setHost(host);
            }
            connector.setPort(this.port);
            connector.setReuseAddress(true);
            this.server.setConnectors(new Connector[]{connector});
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath(AppInfo.get("http.web.root", "/intf"));
            context.addEventListener((EventListener)((Object)new SumkLoaderListener()));
            this.addUserListener(context, Arrays.asList(ServletContextListener.class, ContextHandler.ContextScopeListener.class));
            String resourcePath = AppInfo.get("http.resource");
            if (StringUtils.isNotEmpty(resourcePath)) {
                ResourceHandler resourceHandler = new ResourceHandler();
                resourceHandler.setResourceBase(resourcePath);
                context.insertHandler((HandlerWrapper)resourceHandler);
            }
            this.server.setHandler((Handler)context);
            this.server.start();
            this.started = true;
        }
        catch (Exception e) {
            Log.printStack(e);
            System.exit(-1);
        }
    }

    private void addUserListener(ServletContextHandler context, List<Class<? extends EventListener>> intfs) {
        for (Class<? extends EventListener> intf : intfs) {
            List<? extends EventListener> listeners = IOC.getBeans(intf);
            if (CollectionUtils.isEmpty(listeners)) continue;
            listeners.forEach(lis -> context.addEventListener(lis));
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.started = false;
            }
            catch (Exception e) {
                Log.printStack("http", e);
            }
        }
    }
}

