/*
 * Decompiled with CFR 0.152.
 */
package org.yx.listener;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yx.bean.BeanWrapper;
import org.yx.bean.Loader;
import org.yx.bean.watcher.BeanWatcher;
import org.yx.common.Ordered;
import org.yx.conf.AppInfo;
import org.yx.listener.FactorysBean;
import org.yx.log.Log;
import org.yx.util.CollectionUtils;
import org.yx.util.StringUtils;

public abstract class ClassLoaderFactorysBean<T extends Ordered>
implements FactorysBean<T>,
BeanWatcher<T> {
    protected String userPackage;
    protected String sumkPath;
    protected String sumkPackage_pre;
    protected List<T> beans;
    protected Set<T> userBeans = new HashSet<T>();
    protected Comparator<Ordered> comparator;

    public ClassLoaderFactorysBean(String userPackage, String sumkPath, String sumkPackage_pre) {
        this.userPackage = userPackage;
        String string = this.sumkPath = sumkPath == null ? "" : sumkPath.replace('.', '/');
        if (StringUtils.isNotEmpty(sumkPackage_pre)) {
            this.sumkPackage_pre = sumkPackage_pre.endsWith(".") ? sumkPackage_pre : sumkPackage_pre + ".";
        }
    }

    protected void createSumkObject() throws Exception {
        if (StringUtils.isEmpty(this.sumkPath)) {
            return;
        }
        InputStream in = Loader.getResourceAsStream("META-INF/" + this.sumkPath);
        if (in == null) {
            Log.get("sumk.SYS").error(this.sumkPath + " file cannot found");
            return;
        }
        List<String> sumks = CollectionUtils.loadList(in);
        for (String listener : sumks) {
            if (StringUtils.isNotEmpty(this.sumkPackage_pre)) {
                listener = AppInfo.get("sumk.class.load." + listener, this.sumkPackage_pre + listener);
            }
            Class<?> clz = this.getClass().getClassLoader().loadClass(listener);
            if (!this.acceptClass().isAssignableFrom(clz)) {
                Log.get("sumk.ClassLoaderFactorysBean").debug("{} is not a Listener", (Object)listener);
                continue;
            }
            this.beans.add((Ordered)clz.newInstance());
        }
    }

    @Override
    public List<T> create() throws Exception {
        this.beans = new ArrayList<T>();
        this.createSumkObject();
        this.beans.addAll(this.userBeans);
        Collections.sort(this.beans, this.comparator);
        return this.beans;
    }

    @Override
    public void beanPost(BeanWrapper w) {
        Object obj = w.getBean();
        if (this.userPackage != null && this.acceptClass().isInstance(obj) && w.getTargetClass().getName().startsWith(this.userPackage)) {
            this.userBeans.add((Ordered)obj);
        }
    }
}

