/*
 * Decompiled with CFR 0.152.
 */
package org.yx.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.helpers.MarkerIgnoringBase;

public class ConsoleLog
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -3870429620672951725L;
    public static final byte OFF = 1;
    public static final byte ERROR = 3;
    public static final byte WARN = 4;
    public static final byte INFO = 5;
    public static final byte DEBUG = 7;
    public static final byte TRACE = 9;
    public static final byte ON = 100;
    private static final String LEVEL_ERROR = "ERROR";
    private static final String LEVEL_WARN = "WARN";
    private static final String LEVEL_INFO = "INFO";
    private static final String LEVEL_DEBUG = "DEBUG";
    private static final String LEVEL_TRACE = "TRACE";
    private static byte DEFAULT_LEVEL = (byte)5;
    private byte _level = (byte)-1;
    private static Map<String, ConsoleLog> map = new ConcurrentHashMap<String, ConsoleLog>();
    private static ConsoleLog root = new ConsoleLog("sumk");
    private final String name;

    public static ConsoleLog get(String module) {
        if (module == null) {
            return root;
        }
        ConsoleLog log = map.get(module = module.trim());
        if (log != null) {
            return log;
        }
        if (module.isEmpty() || module.equals(ConsoleLog.root.name)) {
            return root;
        }
        log = new ConsoleLog(module);
        map.putIfAbsent(module, log);
        return map.get(module);
    }

    private static byte getLevel(String logName) {
        int index = logName.lastIndexOf(".");
        while (index > 0) {
            ConsoleLog log = map.get(logName = logName.substring(0, index));
            if (log != null && log._level > 0) {
                return log._level;
            }
            index = logName.lastIndexOf(".");
        }
        return DEFAULT_LEVEL;
    }

    private byte getLevel() {
        if (this._level > 0) {
            return this._level;
        }
        if (this.name == null) {
            return DEFAULT_LEVEL;
        }
        String logName = this.name;
        return ConsoleLog.getLevel(logName);
    }

    public static void setDefaultLevel(byte level) {
        if (level > -1) {
            DEFAULT_LEVEL = level;
        }
    }

    private ConsoleLog(String module) {
        this.name = module;
    }

    protected String buildMessage(String msg, Object ... args) {
        if (msg == null) {
            return msg;
        }
        String[] tmps = msg.split("\\{\\}", -1);
        if (tmps.length < 2) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tmps.length - 1; ++i) {
            sb.append(tmps[i]);
            sb.append(args.length > i ? String.valueOf(args[i]) : "{}");
        }
        sb.append(tmps[tmps.length - 1]);
        return sb.toString();
    }

    protected void show(String level, String msg, Object ... args) {
        msg = this.buildMessage(msg, args);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println(format.format(new Date()) + " [" + Thread.currentThread().getName() + "] " + level + " " + this.shorter(this.name) + " - " + msg);
    }

    private String shorter(String name) {
        if (name == null || name.length() < 40) {
            return name;
        }
        return "..." + name.substring(name.length() - 35);
    }

    public void setLevel(byte level) {
        this._level = level;
    }

    public void debug(String msg, Object ... args) {
        if (this.getLevel() < 7) {
            return;
        }
        this.show(LEVEL_DEBUG, msg, args);
    }

    public void trace(String msg, Object ... args) {
        if (this.getLevel() < 9) {
            return;
        }
        this.show(LEVEL_TRACE, msg, args);
    }

    public void info(String msg, Object ... args) {
        if (this.getLevel() < 5) {
            return;
        }
        this.show(LEVEL_INFO, msg, args);
    }

    public void trace(Object msg) {
        if (this.getLevel() < 9) {
            return;
        }
        this.show(LEVEL_TRACE, String.valueOf(msg), new Object[0]);
    }

    public boolean isTraceEnabled() {
        return this.getLevel() >= 9;
    }

    public void trace(String msg) {
        if (this.getLevel() < 9) {
            return;
        }
        this.show(LEVEL_TRACE, msg, new Object[0]);
    }

    public void trace(String format, Object arg) {
        if (this.getLevel() < 9) {
            return;
        }
        this.show(LEVEL_TRACE, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.getLevel() < 9) {
            return;
        }
        this.show(LEVEL_TRACE, format, arg1, arg2);
    }

    public void trace(String msg, Throwable t) {
        if (this.getLevel() < 9) {
            return;
        }
        t.printStackTrace();
    }

    public boolean isDebugEnabled() {
        return this.getLevel() >= 7;
    }

    public void debug(String msg) {
        if (this.getLevel() < 7) {
            return;
        }
        this.show(LEVEL_DEBUG, msg, new Object[0]);
    }

    public void debug(String format, Object arg) {
        if (this.getLevel() < 7) {
            return;
        }
        this.show(LEVEL_DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.getLevel() < 7) {
            return;
        }
        this.show(LEVEL_DEBUG, format, arg1, arg2);
    }

    public void debug(String msg, Throwable t) {
        if (this.getLevel() < 7) {
            return;
        }
        t.printStackTrace();
    }

    public boolean isInfoEnabled() {
        return this.getLevel() >= 5;
    }

    public void info(String msg) {
        if (this.getLevel() < 5) {
            return;
        }
        this.show(LEVEL_INFO, msg, new Object[0]);
    }

    public void info(String format, Object arg) {
        if (this.getLevel() < 5) {
            return;
        }
        this.show(LEVEL_INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.getLevel() < 5) {
            return;
        }
        this.show(LEVEL_INFO, format, arg1, arg2);
    }

    public void info(String msg, Throwable t) {
        if (this.getLevel() < 5) {
            return;
        }
        t.printStackTrace();
    }

    public boolean isWarnEnabled() {
        return this.getLevel() >= 4;
    }

    public void warn(String msg) {
        if (this.getLevel() < 4) {
            return;
        }
        this.show(LEVEL_WARN, msg, new Object[0]);
    }

    public void warn(String format, Object arg) {
        if (this.getLevel() < 4) {
            return;
        }
        this.show(LEVEL_WARN, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.getLevel() < 4) {
            return;
        }
        this.show(LEVEL_WARN, format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        if (this.getLevel() < 4) {
            return;
        }
        t.printStackTrace();
    }

    public void warn(String format, Object ... arguments) {
        if (this.getLevel() < 4) {
            return;
        }
        this.show(LEVEL_WARN, format, arguments);
    }

    public boolean isErrorEnabled() {
        return this.getLevel() >= 3;
    }

    public void error(String msg) {
        if (this.getLevel() < 3) {
            return;
        }
        this.show(LEVEL_ERROR, msg, new Object[0]);
    }

    public void error(String format, Object arg) {
        if (this.getLevel() < 3) {
            return;
        }
        this.show(LEVEL_ERROR, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.getLevel() < 3) {
            return;
        }
        this.show(LEVEL_ERROR, format, arg1, arg2);
    }

    public void error(String msg, Throwable t) {
        if (this.getLevel() < 3) {
            return;
        }
        t.printStackTrace();
    }

    public void error(String format, Object ... arguments) {
        if (this.getLevel() < 3) {
            return;
        }
        this.show(LEVEL_ERROR, format, arguments);
    }

    public static boolean isEnable(byte level) {
        return DEFAULT_LEVEL >= level;
    }
}

