/*
 * Decompiled with CFR 0.152.
 */
package org.yx.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yx.conf.AppInfo;
import org.yx.log.ConsoleLog;
import org.yx.log.LogType;

public abstract class Log {
    private static LogType logType;

    public static void setLogType(LogType type) {
        logType = type;
    }

    public static boolean isTraceEnable(String module) {
        return Log.get(module).isTraceEnabled();
    }

    public static Logger get(Class<?> clz) {
        return Log.get(clz.getSimpleName());
    }

    public static Logger get(Class<?> clz, Object id) {
        return Log.get(clz.getSimpleName() + "." + String.valueOf(id));
    }

    public static Logger get(String module) {
        if (logType == null || logType == LogType.console) {
            return ConsoleLog.get(module);
        }
        if (module == null || (module = module.trim()).isEmpty()) {
            module = "sumk";
        }
        if (!module.startsWith("sumk")) {
            module = "sumk." + module;
        }
        return LoggerFactory.getLogger((String)module);
    }

    public static void printStack(Throwable e) {
        Log.get("sumk.error").error(e.getMessage(), e);
    }

    public static void printStack(String module, Throwable e) {
        Log.get(module).error(e.getMessage(), e);
    }

    static {
        AppInfo.addObserver((a, b) -> {
            try {
                String logType = AppInfo.get("sumk.logtype", LogType.console.name());
                Log.setLogType(LogType.valueOf(logType));
                int temp = AppInfo.getInt("sumk.loglevel.console", -1);
                if (temp > -1 && temp < 127) {
                    ConsoleLog.setDefaultLevel((byte)temp);
                }
            }
            catch (Exception e) {
                Log.get("sumk.appInfo").info(e.getMessage(), (Throwable)e);
            }
        });
    }
}

