/*
 * Decompiled with CFR 0.152.
 */
package org.yx.main;

import java.io.InputStream;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.yx.bean.IOC;
import org.yx.bean.Loader;
import org.yx.common.StartContext;
import org.yx.http.ServletInfo;
import org.yx.http.filter.HttpLoginWrapper;
import org.yx.http.filter.LoginServlet;
import org.yx.log.Log;
import org.yx.main.SumkServer;
import org.yx.util.CollectionUtils;

public class SumkLoaderListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        Log.get("sumk.http").debug("contextInitialized");
        SumkServer.start("sumk.http.nojetty");
        if (!SumkServer.isHttpEnable()) {
            return;
        }
        ServletContext context = sce.getServletContext();
        this.injectUserServlets(context);
        List servlets = (List)StartContext.inst.get(ServletInfo.class);
        for (ServletInfo info : servlets) {
            Servlet bean = IOC.get(info.getServletClz());
            ServletRegistration.Dynamic dynamic = bean != null ? context.addServlet(info.getPath(), bean) : context.addServlet(info.getPath(), info.getServletClz());
            dynamic.addMapping(new String[]{info.getPath()});
        }
        Object path = StartContext.inst.get(LoginServlet.class);
        if (path != null && String.class.isInstance(path)) {
            String loginPath = (String)path;
            if (!loginPath.startsWith("/")) {
                loginPath = "/" + loginPath;
            }
            Log.get("sumk.http").info("login path:{}", (Object)(context.getContextPath() + loginPath));
            context.addServlet(loginPath, HttpLoginWrapper.class).addMapping(new String[]{loginPath});
        }
        this.addListeners(context);
    }

    private void addListeners(ServletContext context) {
        try {
            InputStream in = Loader.getResourceAsStream("META-INF/http.listeners");
            this.addListener(context, CollectionUtils.loadList(in));
        }
        catch (Exception e) {
            Log.printStack(e);
            return;
        }
    }

    private void addListener(ServletContext context, List<String> intfs) throws ClassNotFoundException {
        for (String intf : intfs) {
            Class<?> clz = Class.forName(intf);
            if (!EventListener.class.isAssignableFrom(clz)) {
                Log.get("sumk.http").info(intf + " is not implement EventListener");
                continue;
            }
            List<?> listeners = IOC.getBeans(clz);
            if (CollectionUtils.isEmpty(listeners)) continue;
            listeners.forEach(lis -> {
                Log.get("sumk.http").trace("add web listener:{}", (Object)lis.getClass().getSimpleName());
                context.addListener(lis);
            });
        }
    }

    private void injectUserServlets(ServletContext context) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        SumkServer.stop();
    }
}

