/*
 * Decompiled with CFR 0.152.
 */
package org.yx.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.yx.bean.BeanPublisher;
import org.yx.bean.IOC;
import org.yx.bean.Plugin;
import org.yx.bean.ScanerFactorysBean;
import org.yx.common.Deamon;
import org.yx.common.StartContext;
import org.yx.conf.AppInfo;
import org.yx.log.Log;
import org.yx.log.LogType;
import org.yx.rpc.client.Rpc;
import org.yx.util.StringUtils;

public class SumkServer {
    private static volatile boolean started = false;
    private static volatile boolean httpEnable;
    private static volatile boolean rpcEnable;
    private static List<Thread> deamonThreads;
    private static volatile boolean destoryed;

    public static synchronized void runDeamon(Deamon runnable, String threadName) {
        if (destoryed) {
            return;
        }
        Runnable r = () -> {
            while (true) {
                try {
                    while (!destoryed) {
                        runnable.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    Log.printStack(e);
                    continue;
                }
                break;
            }
            Log.get("sumk.SYS").info("{} stoped", (Object)threadName);
        };
        Thread t = new Thread(r, threadName);
        t.setDaemon(true);
        t.start();
        deamonThreads.add(t);
    }

    public static boolean isHttpEnable() {
        return httpEnable;
    }

    public static boolean isRpcEnable() {
        return rpcEnable;
    }

    public static void main(String[] args) {
        SumkServer.start(args);
    }

    public static void start() {
        SumkServer.start(new ArrayList<String>());
    }

    public static void start(String ... args) {
        HashSet<String> argSet = new HashSet<String>();
        if (args != null && args.length > 0) {
            argSet.addAll(Arrays.asList(args));
        }
        SumkServer.start(argSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Collection<String> args) {
        Class<SumkServer> clazz = SumkServer.class;
        synchronized (SumkServer.class) {
            if (started) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            started = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                SumkServer.handleSystemArgs();
                SumkServer.handleArgs(args);
                BeanPublisher.addListeners(new ScanerFactorysBean().create());
                ArrayList<String> ps = new ArrayList<String>();
                ps.add(AppInfo.get("sumk.ioc"));
                ps.add(AppInfo.get("org.yx"));
                if (StartContext.inst.get("nosoa") == null && AppInfo.getInt("soa.port", -1) > 0) {
                    ps.add(AppInfo.get("soa"));
                    rpcEnable = true;
                }
                if (StartContext.inst.get("nohttp") == null) {
                    ps.add(AppInfo.get("http"));
                    httpEnable = true;
                }
                BeanPublisher.publishBeans(SumkServer.allPackage(ps));
                if (AppInfo.getBoolean("soa.client.start", false)) {
                    Rpc.init();
                }
            }
            catch (Throwable e) {
                Log.printStack(e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(-1);
            }
            return;
        }
    }

    private static void handleSystemArgs() {
    }

    private static void handleArgs(Collection<String> args) {
        args.forEach(arg -> {
            switch (arg) {
                case "slf4j": {
                    Log.setLogType(LogType.slf4j);
                    break;
                }
                default: {
                    if (arg.contains("=")) {
                        String[] kv = arg.split("=", 2);
                        StartContext.inst.put(kv[0], (Object)kv[1]);
                        break;
                    }
                    StartContext.inst.put((String)arg, (Object)Boolean.TRUE);
                }
            }
        });
    }

    private static List<String> allPackage(List<String> ps) {
        ArrayList<String> list = new ArrayList<String>();
        for (String p : ps) {
            String[] ss;
            if (StringUtils.isEmpty(p)) continue;
            p = p.replace('\uff0c', ',');
            for (String s : ss = p.split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                list.add(s);
            }
        }
        return list;
    }

    public static boolean isDestoryed() {
        return destoryed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Class<SumkServer> clazz = SumkServer.class;
        synchronized (SumkServer.class) {
            if (destoryed) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            destoryed = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            List<Plugin> lifes = IOC.getBeans(Plugin.class);
            if (lifes == null || lifes.isEmpty()) {
                return;
            }
            Collections.reverse(lifes);
            lifes.forEach(b -> {
                try {
                    b.stop();
                }
                catch (Exception e) {
                    Log.printStack(e);
                }
            });
            deamonThreads.forEach(Thread::interrupt);
            deamonThreads.clear();
            Log.get("sumk.SYS").info("sumk server stoped!!!");
            return;
        }
    }

    static {
        deamonThreads = new ArrayList<Thread>(4);
        destoryed = false;
    }
}

