/*
 * Decompiled with CFR 0.152.
 */
package org.yx.redis;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.redis.RedisCallBack;
import org.yx.redis.RedisParamter;
import org.yx.redis.RedisTemplate;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.SafeEncoder;
import redis.clients.util.Slowlog;

public class Redis {
    private String host;
    private int db;
    private int tryCount;
    private JedisPool pool;
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    Redis(JedisPool pool, RedisParamter p) {
        this.pool = pool;
        this.tryCount = p.getTryCount();
        this.host = p.getIp() + ":" + p.getPort();
        this.db = p.getDb();
    }

    public String getHost() {
        return this.host;
    }

    public int getDb() {
        return this.db;
    }

    Jedis jedis() {
        return this.pool.getResource();
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public <T> T exec(RedisCallBack<T> callback) {
        return new RedisTemplate(this).execute(callback);
    }

    private void handleRedisException(Exception e1) {
        if (e1 != null) {
            throw new SumkException(12342422, e1.getMessage(), e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hgetBinarry(String key, String field) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                byte[] byArray = jedis.hget(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
                return byArray;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.get").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.get").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String key, String field, byte[] value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.hset(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hset").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hset").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String key, int seconds, byte[] value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.setex(key.getBytes(UTF8), seconds, value);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.setex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.setex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                byte[] byArray = jedis.get(key.getBytes(UTF8));
                return byArray;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.get").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.get").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.get(key);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.get").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.get").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.type(key);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.type").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.type").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long append(String key, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.append(key, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.append").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.append").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys(String pattern) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.keys(pattern);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.keys").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.keys").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.set(key, value);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.set").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.set").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, String nxxx) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.set(key, value, nxxx);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.set").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.set").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, String nxxx, String expx, int time) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.set(key, value, nxxx, expx, time);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.set").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.set").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, String nxxx, String expx, long time) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.set(key, value, nxxx, expx, time);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.set").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.set").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Boolean bl = jedis.exists(key);
                return bl;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.exists").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.exists").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exists(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.exists(keys);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.exists").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.exists").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rename(String oldkey, String newkey) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.rename(oldkey, newkey);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.rename").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.rename").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sort(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.sort(key);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sort").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sort").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sort(String key, SortingParams sortingParameters) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.sort(key, sortingParameters);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sort").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sort").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.sort(key, sortingParameters, dstkey);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sort").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sort").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sort(String key, String dstkey) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.sort(key, dstkey);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sort").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sort").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> scan(String cursor) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.scan(cursor);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.scan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.scan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> scan(String cursor, ScanParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.scan(cursor, params);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.scan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.scan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> brpop(int timeout, String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.brpop(timeout, key);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.brpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.brpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> brpop(String ... args) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.brpop(args);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.brpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.brpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> brpop(int timeout, String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.brpop(timeout, keys);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.brpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.brpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] dump(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                byte[] byArray = jedis.dump(key);
                return byArray;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.dump").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.dump").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                jedis.subscribe(jedisPubSub, channels);
                continue;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.subscribe").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.subscribe").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterInfo() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterInfo();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterInfo").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterInfo").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterForget(String nodeId) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterForget(nodeId);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterForget").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterForget").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long clusterKeySlot(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.clusterKeySlot(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterKeySlot").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterKeySlot").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterReplicate(String nodeId) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterReplicate(nodeId);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterReplicate").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterReplicate").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> clusterSlaves(String nodeId) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.clusterSlaves(nodeId);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterSlaves").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterSlaves").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterFailover() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterFailover();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterFailover").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterFailover").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> clusterSlots() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.clusterSlots();
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterSlots").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterSlots").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asking() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.asking();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.asking").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.asking").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> pubsubChannels(String pattern) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.pubsubChannels(pattern);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pubsubChannels").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pubsubChannels").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pubsubNumPat() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.pubsubNumPat();
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pubsubNumPat").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pubsubNumPat").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> pubsubNumSub(String ... channels) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Map map = jedis.pubsubNumSub(channels);
                return map;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pubsubNumSub").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pubsubNumSub").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pfadd(String key, String ... elements) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.pfadd(key, elements);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pfadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pfadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pfcount(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                long l = jedis.pfcount(keys);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pfcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pfcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pfcount(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                long l = jedis.pfcount(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pfcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pfcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pfmerge(String destkey, String ... sourcekeys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.pfmerge(destkey, sourcekeys);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pfmerge").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pfmerge").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long geoadd(String key, double longitude, double latitude, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.geoadd(key, longitude, latitude, member);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.geoadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.geoadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.geoadd(key, memberCoordinateMap);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.geoadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.geoadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Double d = jedis.geodist(key, member1, member2, unit);
                return d;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.geodist").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.geodist").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double geodist(String key, String member1, String member2) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Double d = jedis.geodist(key, member1, member2);
                return d;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.geodist").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.geodist").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> geohash(String key, String ... members) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.geohash(key, members);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.geohash").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.geohash").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoCoordinate> geopos(String key, String ... members) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.geopos(key, members);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.geopos").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.geopos").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.georadius(key, longitude, latitude, radius, unit);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.georadius").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.georadius").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.georadius(key, longitude, latitude, radius, unit, param);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.georadius").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.georadius").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> bitfield(String key, String ... arguments) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.bitfield(key, arguments);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.bitfield").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.bitfield").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.del(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.del").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.del").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.del(keys);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.del").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.del").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long renamenx(String oldkey, String newkey) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.renamenx(oldkey, newkey);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.renamenx").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.renamenx").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String randomKey() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.randomKey();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.randomKey").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.randomKey").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String key, int seconds) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.expire(key, seconds);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.expire").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.expire").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expireAt(String key, long unixTime) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.expireAt(key, unixTime);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.expireAt").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.expireAt").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.ttl(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.ttl").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.ttl").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long move(String key, int dbIndex) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.move(key, dbIndex);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.move").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.move").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSet(String key, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.getSet(key, value);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.getSet").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.getSet").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> mget(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.mget(keys);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.mget").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.mget").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String key, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.setnx(key, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.setnx").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.setnx").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String key, int seconds, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.setex(key, seconds, value);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.setex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.setex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mset(String ... keysvalues) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.mset(keysvalues);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.mset").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.mset").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long msetnx(String ... keysvalues) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.msetnx(keysvalues);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.msetnx").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.msetnx").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decrBy(String key, long integer) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.decrBy(key, integer);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.decrBy").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.decrBy").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decr(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.decr(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.decr").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.decr").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incrBy(String key, long integer) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.incrBy(key, integer);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.incrBy").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.incrBy").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double incrByFloat(String key, double value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Double d = jedis.incrByFloat(key, value);
                return d;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.incrByFloat").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.incrByFloat").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.incr(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.incr").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.incr").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String key, String field, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.hset(key, field, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hset").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hset").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.hget(key, field);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hget").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hget").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hsetnx(String key, String field, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.hsetnx(key, field, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hsetnx").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hsetnx").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(String key, Map<String, String> hash) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.hmset(key, hash);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hmset").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hmset").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hmget(String key, String ... fields) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.hmget(key, fields);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hmget").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hmget").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hincrBy(String key, String field, long value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.hincrBy(key, field, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hincrBy").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hincrBy").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double hincrByFloat(String key, String field, double value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Double d = jedis.hincrByFloat(key, field, value);
                return d;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hincrByFloat").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hincrByFloat").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hexists(String key, String field) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Boolean bl = jedis.hexists(key, field);
                return bl;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hexists").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hexists").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(String key, String ... fields) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.hdel(key, fields);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hdel").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hdel").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hlen(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.hlen(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hlen").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hlen").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hkeys(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.hkeys(key);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hkeys").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hkeys").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hvals(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.hvals(key);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hvals").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hvals").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Map map = jedis.hgetAll(key);
                return map;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hgetAll").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hgetAll").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(String key, String ... strings) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.rpush(key, strings);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.rpush").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.rpush").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(String key, String ... strings) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.lpush(key, strings);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.lpush").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.lpush").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.llen(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.llen").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.llen").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> lrange(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.lrange(key, start, end);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.lrange").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.lrange").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ltrim(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.ltrim(key, start, end);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.ltrim").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.ltrim").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lindex(String key, long index) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.lindex(key, index);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.lindex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.lindex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lset(String key, long index, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.lset(key, index, value);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.lset").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.lset").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lrem(String key, long count, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.lrem(key, count, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.lrem").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.lrem").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.lpop(key);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.lpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.lpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpop(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.rpop(key);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.rpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.rpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpoplpush(String srckey, String dstkey) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.rpoplpush(srckey, dstkey);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.rpoplpush").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.rpoplpush").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(String key, String ... members) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.sadd(key, members);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.smembers(key);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.smembers").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.smembers").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(String key, String ... members) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.srem(key, members);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.srem").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.srem").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String spop(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.spop(key);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.spop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.spop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> spop(String key, long count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.spop(key, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.spop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.spop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long smove(String srckey, String dstkey, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.smove(srckey, dstkey, member);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.smove").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.smove").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scard(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.scard(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.scard").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.scard").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean sismember(String key, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Boolean bl = jedis.sismember(key, member);
                return bl;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sismember").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sismember").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> sinter(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.sinter(keys);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sinter").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sinter").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sinterstore(String dstkey, String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.sinterstore(dstkey, keys);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sinterstore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sinterstore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> sunion(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.sunion(keys);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sunion").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sunion").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sunionstore(String dstkey, String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.sunionstore(dstkey, keys);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sunionstore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sunionstore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> sdiff(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.sdiff(keys);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sdiff").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sdiff").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sdiffstore(String dstkey, String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.sdiffstore(dstkey, keys);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sdiffstore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sdiffstore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> srandmember(String key, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.srandmember(key, count);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.srandmember").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.srandmember").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String srandmember(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.srandmember(key);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.srandmember").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.srandmember").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zadd(key, scoreMembers, params);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zadd(key, scoreMembers);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, double score, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zadd(key, score, member);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, double score, String member, ZAddParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zadd(key, score, member, params);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zadd").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zadd").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrange(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrange(key, start, end);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrange").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrange").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrem(String key, String ... members) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zrem(key, members);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrem").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrem").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Double d = jedis.zincrby(key, score, member, params);
                return d;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zincrby").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zincrby").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zincrby(String key, double score, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Double d = jedis.zincrby(key, score, member);
                return d;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zincrby").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zincrby").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrank(String key, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zrank(key, member);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrank").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrank").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrevrank(String key, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zrevrank(key, member);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrank").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrank").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrange(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrange(key, start, end);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrange").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrange").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeWithScores(key, start, end);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcard(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zcard(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zcard").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zcard").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zscore(String key, String member) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Double d = jedis.zscore(key, member);
                return d;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zscore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zscore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String watch(String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.watch(keys);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.watch").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.watch").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> blpop(int timeout, String ... keys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.blpop(timeout, keys);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.blpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.blpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> blpop(String ... args) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.blpop(args);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.blpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.blpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> blpop(int timeout, String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.blpop(timeout, key);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.blpop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.blpop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcount(String key, double min, double max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zcount(key, min, max);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcount(String key, String min, String max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zcount(key, min, max);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, String min, String max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScore(key, min, max);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, double min, double max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScore(key, min, max);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScore(key, min, max, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScore(key, min, max, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScore(key, max, min);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScore(key, max, min);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByRank(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zremrangeByRank(key, start, end);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zremrangeByRank").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zremrangeByRank").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByScore(String key, String start, String end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zremrangeByScore(key, start, end);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zremrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zremrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByScore(String key, double start, double end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zremrangeByScore(key, start, end);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zremrangeByScore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zremrangeByScore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zunionstore(String dstkey, String ... sets) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zunionstore(dstkey, sets);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zunionstore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zunionstore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zunionstore(dstkey, params, sets);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zunionstore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zunionstore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zinterstore(dstkey, params, sets);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zinterstore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zinterstore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zinterstore(String dstkey, String ... sets) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zinterstore(dstkey, sets);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zinterstore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zinterstore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zlexcount(String key, String min, String max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zlexcount(key, min, max);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zlexcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zlexcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByLex(String key, String min, String max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByLex(key, min, max);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByLex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByLex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByLex(key, min, max, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByLex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByLex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByLex(String key, String max, String min) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByLex(key, max, min);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByLex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByLex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByLex(key, max, min, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByLex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByLex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByLex(String key, String min, String max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.zremrangeByLex(key, min, max);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zremrangeByLex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zremrangeByLex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long strlen(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.strlen(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.strlen").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.strlen").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpushx(String key, String ... string) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.lpushx(key, string);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.lpushx").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.lpushx").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long persist(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.persist(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.persist").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.persist").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpushx(String key, String ... string) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.rpushx(key, string);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.rpushx").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.rpushx").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String echo(String string) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string2 = jedis.echo(string);
                return string2;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.echo").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.echo").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.linsert(key, where, pivot, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.linsert").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.linsert").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String brpoplpush(String source, String destination, int timeout) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.brpoplpush(source, destination, timeout);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.brpoplpush").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.brpoplpush").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setbit(String key, long offset, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Boolean bl = jedis.setbit(key, offset, value);
                return bl;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.setbit").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.setbit").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setbit(String key, long offset, boolean value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Boolean bl = jedis.setbit(key, offset, value);
                return bl;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.setbit").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.setbit").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getbit(String key, long offset) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Boolean bl = jedis.getbit(key, offset);
                return bl;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.getbit").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.getbit").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setrange(String key, long offset, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.setrange(key, offset, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.setrange").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.setrange").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getrange(String key, long startOffset, long endOffset) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.getrange(key, startOffset, endOffset);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.getrange").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.getrange").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitpos(String key, boolean value, BitPosParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.bitpos(key, value, params);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.bitpos").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.bitpos").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitpos(String key, boolean value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.bitpos(key, value);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.bitpos").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.bitpos").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> configGet(String pattern) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.configGet(pattern);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.configGet").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.configGet").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String configSet(String parameter, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.configSet(parameter, value);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.configSet").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.configSet").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long publish(String channel, String message) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.publish(channel, message);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.publish").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.publish").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                jedis.psubscribe(jedisPubSub, patterns);
                continue;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.psubscribe").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.psubscribe").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalsha(String sha1, int keyCount, String ... params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Object object = jedis.evalsha(sha1, keyCount, params);
                return object;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.evalsha").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.evalsha").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalsha(String script) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Object object = jedis.evalsha(script);
                return object;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.evalsha").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.evalsha").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Object object = jedis.evalsha(sha1, keys, args);
                return object;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.evalsha").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.evalsha").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Boolean> scriptExists(String ... sha1) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.scriptExists(sha1);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.scriptExists").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.scriptExists").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean scriptExists(String sha1) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Boolean bl = jedis.scriptExists(sha1);
                return bl;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.scriptExists").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.scriptExists").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String scriptLoad(String script) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.scriptLoad(script);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.scriptLoad").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.scriptLoad").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Slowlog> slowlogGet(long entries) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.slowlogGet(entries);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.slowlogGet").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.slowlogGet").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Slowlog> slowlogGet() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.slowlogGet();
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.slowlogGet").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.slowlogGet").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long objectRefcount(String string) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.objectRefcount(string);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.objectRefcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.objectRefcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectEncoding(String string) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string2 = jedis.objectEncoding(string);
                return string2;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.objectEncoding").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.objectEncoding").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long objectIdletime(String string) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.objectIdletime(string);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.objectIdletime").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.objectIdletime").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitcount(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.bitcount(key, start, end);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.bitcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.bitcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitcount(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.bitcount(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.bitcount").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.bitcount").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.bitop(op, destKey, srcKeys);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.bitop").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.bitop").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> sentinelMasters() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.sentinelMasters();
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelMasters").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelMasters").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sentinelReset(String pattern) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.sentinelReset(pattern);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelReset").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelReset").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.sentinelSlaves(masterName);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelSlaves").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelSlaves").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentinelFailover(String masterName) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.sentinelFailover(masterName);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelFailover").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelFailover").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.sentinelMonitor(masterName, ip, port, quorum);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelMonitor").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelMonitor").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentinelRemove(String masterName) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.sentinelRemove(masterName);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelRemove").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelRemove").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.sentinelSet(masterName, parameterMap);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelSet").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelSet").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String restore(String key, int ttl, byte ... serializedValue) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.restore(key, ttl, serializedValue);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.restore").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.restore").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpire(String key, long milliseconds) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.pexpire(key, milliseconds);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pexpire").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pexpire").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.pexpireAt(key, millisecondsTimestamp);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pexpireAt").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pexpireAt").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pttl(String key) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.pttl(key);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.pttl").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.pttl").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String psetex(String key, long milliseconds, String value) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.psetex(key, milliseconds, value);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.psetex").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.psetex").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clientKill(String client) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clientKill(client);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clientKill").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clientKill").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clientSetname(String name) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clientSetname(name);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clientSetname").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clientSetname").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.migrate(host, port, key, destinationDb, timeout);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.migrate").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.migrate").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.hscan(key, cursor, params);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hscan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hscan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.hscan(key, cursor);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.hscan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.hscan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> sscan(String key, String cursor) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.sscan(key, cursor);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sscan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sscan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.sscan(key, cursor, params);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sscan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sscan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.zscan(key, cursor, params);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zscan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zscan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Tuple> zscan(String key, String cursor) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                ScanResult scanResult = jedis.zscan(key, cursor);
                return scanResult;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zscan").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zscan").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterNodes() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterNodes();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterNodes").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterNodes").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readonly() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.readonly();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.readonly").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.readonly").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterMeet(String ip, int port) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterMeet(ip, port);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterMeet").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterMeet").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterReset(JedisCluster.Reset resetType) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterReset(resetType);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterReset").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterReset").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterAddSlots(int ... slots) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterAddSlots(slots);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterAddSlots").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterAddSlots").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterDelSlots(int ... slots) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterDelSlots(slots);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterDelSlots").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterDelSlots").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.georadiusByMember(key, member, radius, unit);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.georadiusByMember").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.georadiusByMember").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.georadiusByMember(key, member, radius, unit, param);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.georadiusByMember").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.georadiusByMember").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterSaveConfig() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterSaveConfig();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterSaveConfig").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterSaveConfig").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long clusterCountKeysInSlot(int slot) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Long l = jedis.clusterCountKeysInSlot(slot);
                return l;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterCountKeysInSlot").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterCountKeysInSlot").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterFlushSlots() {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterFlushSlots();
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterFlushSlots").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterFlushSlots").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterSetSlotStable(int slot) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterSetSlotStable(slot);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterSetSlotStable").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterSetSlotStable").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterSetSlotImporting(int slot, String nodeId) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterSetSlotImporting(slot, nodeId);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterSetSlotImporting").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterSetSlotImporting").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterSetSlotMigrating(int slot, String nodeId) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterSetSlotMigrating(slot, nodeId);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterSetSlotMigrating").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterSetSlotMigrating").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clusterSetSlotNode(int slot, String nodeId) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.clusterSetSlotNode(slot, nodeId);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterSetSlotNode").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterSetSlotNode").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> clusterGetKeysInSlot(int slot, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.clusterGetKeysInSlot(slot, count);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.clusterGetKeysInSlot").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.clusterGetKeysInSlot").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                List list = jedis.sentinelGetMasterAddrByName(masterName);
                return list;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.sentinelGetMasterAddrByName").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.sentinelGetMasterAddrByName").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScoreWithScores(key, min, max);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScoreWithScores(key, min, max);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrangeByScoreWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrangeByScoreWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Set set = jedis.zrevrangeWithScores(key, start, end);
                return set;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.zrevrangeWithScores").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.zrevrangeWithScores").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substr(String key, int start, int end) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                String string = jedis.substr(key, start, end);
                return string;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.substr").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.substr").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, List<String> keys, List<String> args) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Object object = jedis.eval(script, keys, args);
                return object;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.eval").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.eval").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Object object = jedis.eval(script);
                return object;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.eval").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.eval").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, int keyCount, String ... params) {
        Jedis jedis = null;
        Exception e1 = null;
        for (int i = 0; i < this.tryCount; ++i) {
            try {
                jedis = this.pool.getResource();
                Object object = jedis.eval(script, keyCount, params);
                return object;
            }
            catch (Exception e) {
                if (JedisConnectionException.class.isInstance(e) || e.getCause() != null && JedisConnectionException.class.isInstance(e.getCause())) {
                    Log.get("Redis.eval").error("redis connection failed\uff01" + e.getMessage(), (Throwable)e);
                    e1 = e;
                    continue;
                }
                Log.get("Redis.eval").error("redis execute error\uff01" + e.getMessage(), (Throwable)e);
                SumkException.throwException(12342411, e.getMessage(), e);
                continue;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        this.handleRedisException(e1);
        throw new SumkException(12342423, "\u672a\u77e5redis\u5f02\u5e38");
    }

    public String toString() {
        return "Redis [host=" + this.host + ", db=" + this.db + ", tryCount=" + this.tryCount + "]";
    }
}

