/*
 * Decompiled with CFR 0.152.
 */
package org.yx.redis;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.redis.Redis;
import org.yx.redis.RedisParamter;
import org.yx.util.Assert;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisFactory {
    private static final Map<String, Redis> map = new ConcurrentHashMap<String, Redis>();

    private static String toMapKey(String host, int port, int db) {
        return host + "_" + port + "#" + db;
    }

    public static Redis get(String ip) {
        RedisParamter p = RedisParamter.create(ip);
        return RedisFactory.get(null, p);
    }

    public static Redis get(String ip, int port) {
        RedisParamter p = RedisParamter.create(ip, port);
        return RedisFactory.get(null, p);
    }

    public static Redis get(String ip, int port, int timeout) {
        RedisParamter p = RedisParamter.create(ip, port);
        p.setTimeout(timeout);
        return RedisFactory.get(null, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Redis get(JedisPoolConfig config, RedisParamter p) {
        Assert.notNull(p, "redis paramter cannot be null");
        if (p.getTryCount() < 1 || p.getTryCount() > 100) {
            throw new SumkException(54354354, "tryCount\u5fc5\u987b\u4ecb\u4e8e0\u548c100\u4e4b\u95f4");
        }
        String key = RedisFactory.toMapKey(p.getIp(), p.getPort(), p.getDb());
        Redis redis = map.get(key);
        if (redis != null) return redis;
        Class<RedisFactory> clazz = RedisFactory.class;
        synchronized (RedisFactory.class) {
            if (map.containsKey(key)) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return map.get(key);
            }
            JedisPool pool = RedisFactory.create(config, p.getIp(), p.getPort(), p.getTimeout(), p.getPassword(), p.getDb());
            redis = new Redis(pool, p);
            map.put(key, redis);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return redis;
        }
    }

    private static JedisPool create(JedisPoolConfig config, String host, int port, int timeout, String password, int database) {
        if (config == null) {
            config = RedisFactory.defaultPoolConfig();
        }
        Log.get(RedisFactory.class, "create").info("create redis pool,host={},port={},db={}", new Object[]{host, port, database});
        return new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password, database);
    }

    private static JedisPoolConfig defaultPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(1);
        config.setMaxIdle(20);
        config.setMaxTotal(100);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(300000L);
        config.setNumTestsPerEvictionRun(3);
        return config;
    }
}

