/*
 * Decompiled with CFR 0.152.
 */
package org.yx.redis;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.yx.log.Log;
import org.yx.redis.Redis;
import org.yx.redis.RedisFactory;
import org.yx.redis.RedisParamter;
import org.yx.redis.RedisPool;
import org.yx.util.CollectionUtils;
import org.yx.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public class RedisLoader {
    private static JedisPoolConfig defaultConfig = null;
    private static final String SLAVE_PRE = "slave.";

    public static JedisPoolConfig getDefaultConfig() {
        return defaultConfig;
    }

    public static void setDefaultConfig(JedisPoolConfig defaultConfig) {
        RedisLoader.defaultConfig = defaultConfig;
    }

    public static void init() throws Exception {
        try {
            RedisLoader.loadRedisByConfig();
        }
        catch (Exception e) {
            Log.get(RedisLoader.class).error("failed to load redis pool from redis.properties");
            throw e;
        }
    }

    private static void loadRedisByConfig() throws IOException, Exception {
        String file = "redis.properties";
        InputStream in = RedisLoader.class.getClassLoader().getResourceAsStream(file);
        if (in == null) {
            Log.get("sumk.SYS").info("can not found redis property file:{}", (Object)file);
            return;
        }
        Map<String, String> p = CollectionUtils.loadMap(in);
        Log.get(RedisLoader.class).debug("config:{}", p);
        Set<String> keys = p.keySet();
        for (String kk : keys) {
            String[] moduleKeys;
            if (StringUtils.isEmpty(kk)) continue;
            String v = p.get(kk);
            if (kk.startsWith(SLAVE_PRE)) {
                RedisLoader.createReadRedis(kk.substring(SLAVE_PRE.length()), v.split(","));
                continue;
            }
            Redis redis = RedisLoader.create(v);
            for (String key : moduleKeys = kk.split(",")) {
                if (StringUtils.isEmpty(key = key.toLowerCase()) || StringUtils.isEmpty(v)) continue;
                if ("default".equals(key)) {
                    RedisPool._defaultRedis = redis;
                    continue;
                }
                RedisPool.put(key, redis);
            }
        }
    }

    private static void createReadRedis(String host, String[] redisParams) throws Exception {
        if (StringUtils.isEmpty(host) || redisParams.length == 0 || !host.contains(":")) {
            return;
        }
        ArrayList<RedisParamter> list = new ArrayList<RedisParamter>();
        for (String param : redisParams) {
            if (StringUtils.isEmpty(param = param.trim())) continue;
            list.add(RedisLoader.createParam(param));
        }
        if (list.isEmpty()) {
            return;
        }
        RedisPool.attachRead(host, list.toArray(new RedisParamter[list.size()]));
    }

    private static RedisParamter createParam(String v) throws Exception {
        RedisParamter param;
        String[] params = v.split("#");
        String ip = params[0];
        if (ip.contains(":")) {
            String[] addr = ip.split(":");
            ip = addr[0];
            param = RedisParamter.create(ip, Integer.parseInt(addr[1]));
        } else {
            param = RedisParamter.create(ip);
        }
        if (params.length > 1 && !StringUtils.isEmpty(params[1])) {
            param.setDb(Integer.parseInt(params[1]));
        }
        if (params.length > 2 && !StringUtils.isEmpty(params[2])) {
            param.setPassword(params[2]);
        }
        if (params.length > 3 && !StringUtils.isEmpty(params[3])) {
            param.setTimeout(Integer.parseInt(params[3]));
        }
        if (params.length > 4 && !StringUtils.isEmpty(params[4])) {
            param.setTryCount(Integer.parseInt(params[4]));
        }
        return param;
    }

    private static Redis create(String v) throws Exception {
        return RedisFactory.get(defaultConfig, RedisLoader.createParam(v));
    }
}

