/*
 * Decompiled with CFR 0.152.
 */
package org.yx.redis;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.yx.conf.AppInfo;
import org.yx.log.Log;
import org.yx.redis.Redis;
import org.yx.redis.RedisCounter;
import org.yx.redis.RedisLoader;
import org.yx.redis.RedisParamter;
import org.yx.util.SeqUtil;

public class RedisPool {
    private static final Map<String, Redis> map = new ConcurrentHashMap<String, Redis>();
    private static final Map<String, RedisParamter[]> readParamsMap = new ConcurrentHashMap<String, RedisParamter[]>();
    static Redis _defaultRedis;

    public static Redis get(String alias) {
        if (alias == null) {
            return _defaultRedis;
        }
        Redis r = map.get(alias = alias.toLowerCase());
        if (r != null) {
            return r;
        }
        return _defaultRedis;
    }

    public static Redis getRedisExactly(String alias) {
        alias = alias.toLowerCase();
        return map.get(alias);
    }

    public static Redis defaultRedis() {
        return _defaultRedis;
    }

    public static void put(String alias, Redis redis) {
        map.putIfAbsent(alias.toLowerCase(), redis);
    }

    static void attachRead(String host, RedisParamter[] reads) {
        readParamsMap.put(host, reads);
    }

    static {
        try {
            RedisLoader.init();
            Redis counter = RedisPool.getRedisExactly(AppInfo.get("sumk.counter.name", "counter"));
            if (counter == null) {
                counter = RedisPool.getRedisExactly("session");
            }
            if (counter != null) {
                SeqUtil.setCounter(new RedisCounter(counter));
            }
        }
        catch (Exception e) {
            Log.printStack(e);
            System.exit(-1);
        }
    }
}

