/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.yx.util.GsonUtil;

public final class ZkClientHolder {
    private static final Map<String, ZkClient> map = new ConcurrentHashMap<String, ZkClient>();
    private static Charset defaultCharset = StandardCharsets.UTF_8;
    public static final String SOA_ROOT = "/SUMK_SOA";

    public static void makeSure(ZkClient client, String dataPath) {
        int index;
        int start = 0;
        do {
            if ((index = dataPath.indexOf("/", start + 1)) == start + 1) {
                return;
            }
            String path = dataPath;
            if (index > 0) {
                path = dataPath.substring(0, index);
                start = index;
            }
            if (client.exists(path)) continue;
            client.createPersistent(path);
        } while (index >= 0 && index != dataPath.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZkClient getZkClient(String url) {
        ZkClient zk = map.get(url);
        if (zk != null) {
            return zk;
        }
        Class<ZkClientHolder> clazz = ZkClientHolder.class;
        synchronized (ZkClientHolder.class) {
            zk = map.get(url);
            if (zk != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return zk;
            }
            zk = new ZkClient(url, 30000);
            zk.setZkSerializer(new ZkSerializer(){

                public byte[] serialize(Object data) throws ZkMarshallingError {
                    if (byte[].class.isInstance(data)) {
                        return (byte[])data;
                    }
                    if (String.class.isInstance(data)) {
                        return ((String)data).getBytes(defaultCharset);
                    }
                    return GsonUtil.toJson(data).getBytes(defaultCharset);
                }

                public Object deserialize(byte[] bytes) throws ZkMarshallingError {
                    if (bytes.length == 0) {
                        return null;
                    }
                    return new String(bytes, defaultCharset);
                }
            });
            if (map.putIfAbsent(url, zk) != null) {
                zk.close();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return map.get(url);
        }
    }
}

