/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client;

import org.apache.mina.core.future.WriteFuture;
import org.yx.exception.ConnectionException;
import org.yx.exception.SoaException;
import org.yx.rpc.Host;
import org.yx.rpc.client.Req;
import org.yx.rpc.client.ReqResp;
import org.yx.rpc.client.ReqSession;
import org.yx.rpc.client.ReqSessionHolder;
import org.yx.rpc.client.RequestLocker;
import org.yx.rpc.client.RespFuture;
import org.yx.rpc.client.route.Routes;
import org.yx.rpc.client.route.WeightedRoute;

class ReqSender {
    ReqSender() {
    }

    public static ReqResp send(Req req, long timeout) throws Throwable {
        Host url;
        String method = req.getMethod();
        WeightedRoute route = Routes.getRoute(method);
        if (route == null) {
            SoaException.throwException(2353454, "can not find route for " + method, null);
        }
        if ((url = route.getUrl()) == null) {
            SoaException.throwException(345234, "route for " + method + " are all disabled", null);
        }
        ReqSession session = ReqSessionHolder.getSession(url);
        RespFuture future = RequestLocker.register(req);
        WriteFuture f = session.write(req);
        if (f.getException() != null) {
            throw new ConnectionException(345, f.getException().getMessage(), route.getUrl());
        }
        return future.getResponse(timeout);
    }

    public static RespFuture sendAsync(Req req) {
        String method = req.getMethod();
        WeightedRoute route = Routes.getRoute(method);
        if (route == null) {
            SoaException.throwException(2353454, "can not find route for " + method, null);
        }
        ReqSession session = ReqSessionHolder.getSession(route.getUrl());
        RespFuture future = RequestLocker.register(req);
        WriteFuture f = session.write(req);
        if (f.getException() != null) {
            throw new ConnectionException(345, f.getException().getMessage(), route.getUrl());
        }
        return future;
    }
}

