/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client;

import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.yx.exception.ConnectionException;
import org.yx.log.Log;
import org.yx.rpc.Host;
import org.yx.rpc.client.ClientHandler;
import org.yx.rpc.client.Req;
import org.yx.rpc.codec.SumkCodecFactory;

public class ReqSession {
    protected IoSession session;
    private NioSocketConnector connector;
    private Host addr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSession() {
        if (this.session != null && !this.session.isClosing()) {
            return;
        }
        ReqSession reqSession = this;
        synchronized (reqSession) {
            if (this.connector == null || this.connector.isDisposing() || this.connector.isDisposed()) {
                Log.get("sumk.rpc").debug("create connector for {}", (Object)this.addr);
                this.connector = new NioSocketConnector(1);
                this.connector.setConnectTimeoutMillis(5000L);
                this.connector.setHandler((IoHandler)new ClientHandler());
                this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)SumkCodecFactory.factory()));
            }
            if (this.session == null || this.session.isClosing()) {
                Log.get("sumk.rpc").debug("create session for {}", (Object)this.addr);
                ConnectFuture cf = this.connector.connect((SocketAddress)this.addr.toInetSocketAddress());
                cf.awaitUninterruptibly(this.connector.getConnectTimeoutMillis() + 1L);
                try {
                    IoSession se = cf.getSession();
                    if (se != null) {
                        this.session = se;
                        return;
                    }
                    cf.cancel();
                }
                catch (Exception e) {
                    throw new ConnectionException(7311234, "error in create channel.cause by " + e.getMessage(), this.addr);
                }
                throw new ConnectionException(6454345, "error in create channel", this.addr);
            }
        }
    }

    public ReqSession(Host host) {
        this.addr = host;
    }

    public WriteFuture write(Req req) {
        this.ensureSession();
        return this.session.write((Object)req);
    }

    public void close() {
        this.session.close(true);
    }
}

