/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.yx.exception.SoaException;
import org.yx.rpc.client.Req;
import org.yx.rpc.client.ReqResp;
import org.yx.rpc.client.RequestLocker;
import org.yx.rpc.server.Response;

class RespFuture {
    Response resp = null;
    private Req req;
    private Thread thread;

    public RespFuture(Req req) {
        this.req = req;
        this.thread = Thread.currentThread();
    }

    void unpark() {
        LockSupport.unpark(this.thread);
    }

    ReqResp getResponse(long timeout) {
        long start = this.req.getStart() > 100000L ? this.req.getStart() : System.currentTimeMillis();
        long end = start + timeout;
        do {
            LockSupport.parkUntil(end);
        } while (this.resp == null && RequestLocker.locks.containsKey(this.req.getSn()) && end > System.currentTimeMillis());
        if (this.resp == null) {
            String msg = "timeout in " + timeout + "ms,sn=" + this.req.getSn();
            SoaException.throwException(142234, msg, new TimeoutException(msg));
        }
        return new ReqResp(this.req, this.resp);
    }
}

