/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.yx.common.ThreadContext;
import org.yx.conf.AppInfo;
import org.yx.exception.ConnectionException;
import org.yx.exception.SoaException;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.rpc.RpcUtils;
import org.yx.rpc.client.Req;
import org.yx.rpc.client.ReqResp;
import org.yx.rpc.client.ReqSender;
import org.yx.rpc.client.route.HostChecker;
import org.yx.rpc.client.route.ZkRouteParser;
import org.yx.util.GsonUtil;
import org.yx.util.UUIDSeed;

public final class Rpc {
    private static Map<String, Long> TimeoutMap = new ConcurrentHashMap<String, Long>();
    private static long DEFAULT_TIMEOUT;
    private static volatile boolean strated;

    private static String getAppId() {
        return AppInfo.getAppId();
    }

    public static synchronized void init() {
        if (strated) {
            return;
        }
        try {
            DEFAULT_TIMEOUT = AppInfo.getInt("soa.timeout", 30000);
            String zkUrl = AppInfo.getZKUrl();
            Log.get("sumk.rpc").info("zkUrl:{}", (Object)zkUrl);
            ZkRouteParser.get(zkUrl).readRouteAndListen();
            strated = true;
        }
        catch (Exception e) {
            throw SumkException.create(e);
        }
    }

    private static Req createReq(String method) {
        Req req = new Req();
        req.setStart(System.currentTimeMillis());
        String sn = UUIDSeed.random();
        req.setSn(sn);
        String sn0 = ThreadContext.get().getSn0();
        if (sn0 != null) {
            req.setSn0(sn);
        }
        req.setMethod(method);
        req.setSrc(Rpc.getAppId());
        return req;
    }

    private static String call0(Req req) {
        ReqResp reqResp;
        try {
            reqResp = ReqSender.send(req, TimeoutMap.getOrDefault(RpcUtils.getAppId(req.getMethod()), DEFAULT_TIMEOUT));
        }
        catch (SoaException ex) {
            throw ex;
        }
        catch (Throwable e) {
            if (ConnectionException.class.isInstance(e)) {
                HostChecker.instance().addDownUrl(((ConnectionException)ConnectionException.class.cast(e)).getHost());
            }
            Log.printStack(e);
            throw new SoaException(1022, e.getMessage(), e);
        }
        reqResp.getResp().checkException();
        return reqResp.getResp().getJson();
    }

    public static String call(String method, Object ... args) {
        Req req = Rpc.createReq(method);
        String[] params = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            params[i] = GsonUtil.toJson(args[i]);
        }
        req.setParamArray(params);
        return Rpc.call0(req);
    }

    public static String callInJson(String method, String arg) {
        Req req = Rpc.createReq(method);
        req.setJsonedParam(arg);
        return Rpc.call0(req);
    }

    public static String callInMap(String method, String arg) {
        return Rpc.callInJson(method, GsonUtil.toJson(arg));
    }
}

