/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client.route;

import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.yx.common.Deamon;
import org.yx.conf.AppInfo;
import org.yx.log.Log;
import org.yx.main.SumkServer;
import org.yx.rpc.Host;

public class HostChecker {
    private static HostChecker holder = new HostChecker();
    private static long maxDownTime = AppInfo.getInt("soa.checker.maxtime", 120000);
    private ConcurrentHashMap<Host, Long> downUrls = new ConcurrentHashMap();

    private HostChecker() {
        SumkServer.runDeamon(new checker(), "host-checker");
    }

    public static HostChecker instance() {
        return holder;
    }

    public boolean isDowned(Host url) {
        return this.downUrls.containsKey(url);
    }

    public List<Host> available(List<Host> urls) {
        ArrayList<Host> us = new ArrayList<Host>(urls);
        ArrayList<Host> avas = new ArrayList<Host>(us.size());
        for (Host u : us) {
            if (this.downUrls.containsKey(u)) continue;
            avas.add(u);
        }
        return avas;
    }

    public void addDownUrl(Host url) {
        this.downUrls.putIfAbsent(url, System.currentTimeMillis());
    }

    private class checker
    implements Deamon {
        private checker() {
        }

        @Override
        public void run() throws InterruptedException {
            this.check();
            long t = 5000 - 2000 * HostChecker.this.downUrls.size();
            if (t > 0L) {
                Thread.sleep(t);
            }
        }

        private int getTimeOut(int urlSize) {
            if (urlSize == 1) {
                return 3000;
            }
            if (urlSize == 2) {
                return 2500;
            }
            if (urlSize > 5) {
                return 1000;
            }
            return 2000;
        }

        private void check() {
            if (HostChecker.this.downUrls.isEmpty()) {
                return;
            }
            Host[] urls = ((ConcurrentHashMap.CollectionView)((Object)HostChecker.this.downUrls.keySet())).toArray(new Host[0]);
            int timeout = this.getTimeOut(urls.length);
            for (Host url : urls) {
                try {
                    long t = (Long)HostChecker.this.downUrls.get(url);
                    if (System.currentTimeMillis() - t >= maxDownTime) {
                        HostChecker.this.downUrls.remove(url);
                        continue;
                    }
                    Socket socket = new Socket();
                    socket.connect(url.toInetSocketAddress(), timeout);
                    if (!socket.isConnected()) continue;
                    socket.close();
                    HostChecker.this.downUrls.remove(url);
                }
                catch (UnknownHostException e) {
                    Log.get("sumk.SYS").error(e.getMessage(), (Throwable)e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

