/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client.route;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.yx.rpc.Host;
import org.yx.rpc.client.route.RouteEvent;
import org.yx.rpc.client.route.ServerMachine;
import org.yx.rpc.client.route.WeightedRoute;
import org.yx.rpc.client.route.ZkData;

public class Routes {
    private final Map<String, WeightedRoute> routes;
    private final Map<Host, ZkData> zkDatas;
    private static volatile Routes ROUTE = new Routes(Collections.emptyMap(), Collections.emptyMap());

    private Routes(Map<Host, ZkData> zkDatas, Map<String, WeightedRoute> routes) {
        this.zkDatas = zkDatas;
        this.routes = routes;
    }

    public static WeightedRoute getRoute(String method) {
        Map<String, WeightedRoute> routes = Routes.ROUTE.routes;
        WeightedRoute r;
        while ((r = routes.get(method)) == null) {
            if (!method.contains(".")) {
                return null;
            }
            method = method.substring(0, method.lastIndexOf("."));
        }
        return r;
    }

    private static void _refresh(Map<Host, ZkData> data, Map<String, WeightedRoute> route) {
        Routes r;
        ROUTE = r = new Routes(data, route);
    }

    static void handle(RouteEvent event) {
        HashMap<Host, ZkData> data = new HashMap<Host, ZkData>(Routes.ROUTE.zkDatas);
        switch (event.getType()) {
            case CREATE: 
            case MODIFY: {
                data.put(event.getUrl(), event.getZkData());
                break;
            }
            case DELETE: {
                if (data.remove(event.getUrl()) != null) break;
                return;
            }
        }
        Routes.refresh(data);
    }

    public static synchronized void refresh(Map<Host, ZkData> datas) {
        HashMap<String, HashSet<ServerMachine>> map = new HashMap<String, HashSet<ServerMachine>>();
        for (Host url : datas.keySet()) {
            Map<String, ServerMachine> ms = Routes.createServerMachine(url, datas.get(url));
            for (String m : ms.keySet()) {
                HashSet<ServerMachine> server = (HashSet<ServerMachine>)map.get(m);
                if (server == null) {
                    server = new HashSet<ServerMachine>();
                    map.put(m, server);
                }
                server.add(ms.get(m));
            }
        }
        HashMap<String, WeightedRoute> routes = new HashMap<String, WeightedRoute>();
        for (String method : map.keySet()) {
            routes.put(method, new WeightedRoute((Collection)map.get(method)));
        }
        Routes._refresh(datas, routes);
    }

    private static Map<String, ServerMachine> createServerMachine(Host url, ZkData data) {
        HashMap<String, ServerMachine> servers = new HashMap<String, ServerMachine>();
        int weight = data.weight > 0 ? data.weight : 5;
        data.getIntfs().forEach(intf -> {
            ServerMachine server = new ServerMachine(url, weight);
            servers.put(intf.getIntf(), server);
        });
        return servers;
    }
}

