/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client.route;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.yx.rpc.Host;
import org.yx.rpc.client.route.HostChecker;
import org.yx.rpc.client.route.ServerMachine;

public class WeightedRoute {
    private volatile int currentIndex = -1;
    private volatile int currentWeight = 0;
    private int maxWeight;
    private int gcdWeight;
    private List<ServerMachine> serverList;

    private static int gcd(int a, int b) {
        BigInteger b1 = new BigInteger(String.valueOf(a));
        BigInteger b2 = new BigInteger(String.valueOf(b));
        BigInteger gcd = b1.gcd(b2);
        return gcd.intValue();
    }

    private static int getGCDForServers(List<ServerMachine> serverList) {
        int w = 0;
        int len = serverList.size();
        for (int i = 0; i < len - 1; ++i) {
            w = w == 0 ? WeightedRoute.gcd(serverList.get((int)i).weight, serverList.get((int)(i + 1)).weight) : WeightedRoute.gcd(w, serverList.get((int)(i + 1)).weight);
        }
        return w;
    }

    private static int getMaxWeightForServers(List<ServerMachine> serverList) {
        int w = 0;
        for (ServerMachine s : serverList) {
            if (s.getWeight() <= w) continue;
            w = s.getWeight();
        }
        return w;
    }

    public Host getUrl() {
        ServerMachine sm = this.GetServer();
        if (sm == null) {
            return null;
        }
        return sm.getUrl();
    }

    private ServerMachine GetServer() {
        List<ServerMachine> list = this.serverList;
        int serverCount = list.size();
        for (int i = 0; i < serverCount * 2; ++i) {
            this.currentIndex = (this.currentIndex + 1) % serverCount;
            if (this.currentIndex == 0) {
                this.currentWeight -= this.gcdWeight;
                if (this.currentWeight <= 0) {
                    this.currentWeight = this.maxWeight;
                    if (this.currentWeight == 0) {
                        return null;
                    }
                }
            }
            int index = this.currentIndex % serverCount;
            if (list.get((int)index).weight < this.currentWeight || HostChecker.instance().isDowned(list.get(index).getUrl())) continue;
            return list.get(index);
        }
        return null;
    }

    public void addServer(ServerMachine s) {
        ArrayList<ServerMachine> list = new ArrayList<ServerMachine>(this.serverList);
        list.add(s);
        this.init(list);
    }

    public void removeServer(Host url) {
        ArrayList<ServerMachine> list = new ArrayList<ServerMachine>(this.serverList);
        for (ServerMachine s : list) {
            if (!s.getUrl().equals(url)) continue;
            list.remove(s);
            break;
        }
        this.init(list);
    }

    public WeightedRoute(ServerMachine ... servers) {
        ArrayList<ServerMachine> list = new ArrayList<ServerMachine>();
        Arrays.stream(servers).forEach(s -> list.add((ServerMachine)s));
        this.init(list);
    }

    public WeightedRoute(Collection<ServerMachine> servers) {
        this.init(servers);
    }

    private void init(Collection<ServerMachine> list) {
        this.serverList = new ArrayList<ServerMachine>(list.size());
        this.serverList.addAll(list);
        this.maxWeight = WeightedRoute.getMaxWeightForServers(this.serverList);
        this.gcdWeight = WeightedRoute.getGCDForServers(this.serverList);
    }
}

