/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.client.route;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.yx.main.SumkServer;
import org.yx.rpc.Host;
import org.yx.rpc.ZkClientHolder;
import org.yx.rpc.client.route.IntfInfo;
import org.yx.rpc.client.route.RouteEvent;
import org.yx.rpc.client.route.Routes;
import org.yx.rpc.client.route.ZkData;
import org.yx.util.CollectionUtils;
import org.yx.util.GsonUtil;
import org.yx.util.StringUtils;

public class ZkRouteParser {
    private String zkUrl;
    private Set<String> childs = Collections.emptySet();
    private BlockingQueue<RouteEvent> queue = new LinkedBlockingQueue<RouteEvent>();

    private ZkRouteParser(String zkUrl) {
        this.zkUrl = zkUrl;
    }

    public static ZkRouteParser get(String zkUrl) {
        return new ZkRouteParser(zkUrl);
    }

    public void readRouteAndListen() throws IOException {
        HashMap<Host, ZkData> datas = new HashMap<Host, ZkData>();
        final ZkClient zk = ZkClientHolder.getZkClient(this.zkUrl);
        List paths = zk.getChildren("/SUMK_SOA");
        this.childs = new HashSet<String>(paths);
        final IZkDataListener nodeListener = new IZkDataListener(){
            ZkRouteParser parser;
            {
                this.parser = ZkRouteParser.this;
            }

            public void handleDataChange(String dataPath, Object data) throws Exception {
                ServerData d = this.parser.getZkNodeData(dataPath);
                if (d == null) {
                    this.parser.handle(RouteEvent.delete(Host.create(dataPath)));
                    return;
                }
                this.parser.handle(RouteEvent.create(d.url, d.data));
            }

            public void handleDataDeleted(String dataPath) throws Exception {
            }
        };
        zk.subscribeChildChanges("/SUMK_SOA", new IZkChildListener(){
            ZkRouteParser parser;
            {
                this.parser = ZkRouteParser.this;
            }

            public synchronized void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
                ArrayList<String> createChilds = new ArrayList<String>();
                HashSet deleteChilds = new HashSet(this.parser.childs);
                for (String zkChild : currentChilds) {
                    boolean exist = deleteChilds.remove(zkChild);
                    if (exist) continue;
                    createChilds.add(zkChild);
                }
                this.parser.childs = new HashSet<String>(currentChilds);
                for (String create : createChilds) {
                    ServerData d = this.parser.getZkNodeData(create);
                    if (d == null) continue;
                    this.parser.handle(RouteEvent.create(d.url, d.data));
                    zk.subscribeDataChanges(parentPath + "/" + create, nodeListener);
                }
                for (String delete : deleteChilds) {
                    this.parser.handle(RouteEvent.delete(Host.create(delete)));
                }
            }
        });
        for (String path : paths) {
            ServerData d = this.getZkNodeData(path);
            zk.subscribeDataChanges("/SUMK_SOA/" + path, nodeListener);
            if (d == null) continue;
            datas.put(d.url, d.data);
        }
        Routes.refresh(datas);
        SumkServer.runDeamon(() -> {
            RouteEvent event = this.queue.take();
            if (event == null) {
                return;
            }
            Routes.handle(event);
        }, "rpc-client-route");
    }

    private ServerData getZkNodeData(String path) throws IOException {
        Host url = Host.create(path);
        ZkClient zk = ZkClientHolder.getZkClient(this.zkUrl);
        String json = (String)zk.readData("/SUMK_SOA/" + path);
        Map<String, String> map = CollectionUtils.loadMap(new StringReader(json));
        String methods = map.get("methods");
        if (StringUtils.isEmpty(methods)) {
            return null;
        }
        ZkData data = new ZkData();
        data.setWeight(map.get("weight"));
        Arrays.stream(methods.split(",")).forEach(m -> {
            if (m.startsWith("{")) {
                IntfInfo intf = GsonUtil.fromJson(m, IntfInfo.class);
                data.addIntf(intf);
                return;
            }
            IntfInfo intf = new IntfInfo();
            intf.setIntf((String)m);
            data.addIntf(intf);
        });
        return new ServerData(url, data);
    }

    public void handle(RouteEvent event) {
        if (event == null) {
            return;
        }
        this.queue.offer(event);
    }

    private static class ServerData {
        final Host url;
        final ZkData data;

        private ServerData(Host url, ZkData data) {
            this.url = url;
            this.data = data;
        }
    }
}

