/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.codec;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.yx.conf.Profile;
import org.yx.log.Log;
import org.yx.rpc.codec.MessageDeserializer;

public class SumkProtocolDecoder
extends CumulativeProtocolDecoder {
    private Charset charset = Profile.CHARSET_DEFAULT;
    private MessageDeserializer msgDeserializer = new MessageDeserializer();

    protected boolean doDecodeString(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws CharacterCodingException, ProtocolDecoderException {
        int pos = in.position();
        int protocol = in.getInt();
        int prefixLength = 0;
        int maxDataLength = 0;
        if ((protocol & 1) != 0) {
            prefixLength = 1;
            maxDataLength = 255;
        } else if ((protocol & 2) != 0) {
            prefixLength = 2;
            maxDataLength = 65535;
        } else if ((protocol & 4) != 0) {
            prefixLength = 4;
            maxDataLength = 0x3FFFFFFF;
        } else {
            throw new ProtocolDecoderException("error transport protocol," + Integer.toHexString(protocol));
        }
        if (in.prefixedDataAvailable(prefixLength, maxDataLength)) {
            String msg = in.getPrefixedString(prefixLength, this.charset.newDecoder());
            if (msg == null || msg.isEmpty()) {
                return true;
            }
            out.write(this.msgDeserializer.deserialize(protocol, msg));
            return true;
        }
        in.position(pos);
        return false;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws ProtocolDecoderException, CharacterCodingException {
        if (in.remaining() < 4) {
            return false;
        }
        int protocol = in.getInt(in.position());
        if ((protocol & 0xFF000000) != -1895825408) {
            int position = in.position();
            Log.get("sumk.rpc").trace(in.getString(Profile.CHARSET_DEFAULT.newDecoder()));
            in.position(position);
            throw new ProtocolDecoderException("error magic," + Integer.toHexString(protocol));
        }
        if ((protocol & 0x10000) != 0) {
            return this.doDecodeString(session, in, out);
        }
        throw new ProtocolDecoderException("error transport protocol," + Integer.toHexString(protocol));
    }
}

