/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.codec;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.yx.conf.Profile;
import org.yx.log.Log;
import org.yx.rpc.client.Req;
import org.yx.rpc.server.Response;
import org.yx.util.GsonUtil;

public class SumkProtocolEncoder
implements ProtocolEncoder {
    private Charset charset = Profile.CHARSET_DEFAULT;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        if (message == null) {
            return;
        }
        if (Req.class.isInstance(message)) {
            this.encodeReq(session, (Req)message, out);
        } else if (Response.class.isInstance(message)) {
            this.encodeResponse(session, (Response)message, out);
        } else if (String.class.isInstance(message)) {
            this.encodeString(0, session, (String)message, out);
        } else {
            throw new ProtocolEncoderException(message.getClass().getName() + " not support in ProtocolEncoder");
        }
    }

    private void encodeResponse(IoSession session, Response message, ProtocolEncoderOutput out) throws CharacterCodingException, ProtocolEncoderException {
        this.encodeString(4096, session, GsonUtil.toJson(message), out);
    }

    private void putProtocol(int code, IoBuffer buffer, int prefixLength) throws ProtocolEncoderException {
        switch (prefixLength) {
            case 1: {
                buffer.putInt(1 | code | 0x8F000000);
                break;
            }
            case 2: {
                buffer.putInt(2 | code | 0x8F000000);
                break;
            }
            case 4: {
                buffer.putInt(4 | code | 0x8F000000);
                break;
            }
            default: {
                throw new ProtocolEncoderException("error size");
            }
        }
    }

    private void encodeReq(IoSession session, Req req, ProtocolEncoderOutput out) throws CharacterCodingException, ProtocolEncoderException {
        String jsonedArg = req.getJsonedParam();
        String[] params = req.getParamArray();
        req.clearParams();
        if (jsonedArg != null) {
            Log.get("sumk.rpc").trace("args:{}", (Object)jsonedArg);
            String json_req = GsonUtil.toJson(req) + "\n" + jsonedArg;
            this.encodeString(256, session, json_req, out);
            return;
        }
        StringBuilder json_req = new StringBuilder();
        json_req.append(String.format("%02d", params.length)).append(GsonUtil.toJson(req));
        for (String p : params) {
            json_req.append("\n").append(p);
        }
        this.encodeString(512, session, json_req, out);
    }

    private void encodeString(int code, IoSession session, CharSequence message, ProtocolEncoderOutput out) throws CharacterCodingException, ProtocolEncoderException {
        int size = message.length();
        int prefixLength = size <= 80 ? 1 : (size <= 21760 ? 2 : 4);
        IoBuffer buffer = IoBuffer.allocate((int)((int)((double)size * 1.2) + 10)).setAutoExpand(true);
        this.putProtocol(code |= 0x10000, buffer, prefixLength);
        buffer.putPrefixedString(message, prefixLength, this.charset.newEncoder());
        buffer.flip();
        out.write((Object)buffer);
    }

    public void dispose(IoSession session) throws Exception {
    }
}

