/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.server;

import java.util.List;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.yx.exception.BizException;
import org.yx.exception.SoaException;
import org.yx.log.Log;
import org.yx.rpc.server.RequestHandler;
import org.yx.rpc.server.Response;
import org.yx.util.GsonUtil;

public class ServerHandler
extends IoHandlerAdapter {
    private List<RequestHandler> handlers;

    public ServerHandler(List<RequestHandler> handlers) {
        this.handlers = handlers;
    }

    public void addHandler(RequestHandler h) {
        this.handlers.add(h);
    }

    public void sessionCreated(IoSession session) {
        Log.get("sumk.SYS").debug("create session:{}-{}", (Object)session.getServiceAddress(), (Object)session.getId());
    }

    public void sessionClosed(IoSession session) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (session.getIdleCount(status) > 10000) {
            Log.get("sumk.SYS").debug("session:{}, idle:{},will close", (Object)session.getId(), (Object)session.getIdleCount(status));
            session.close(true);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        Log.get("sumk.SYS").error("session:" + session.getId() + ",message:" + cause.getMessage(), cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        block3: {
            try {
                for (RequestHandler h : this.handlers) {
                    if (!h.accept(message)) continue;
                    Object ret = h.received(message);
                    session.write(ret);
                    return;
                }
            }
            catch (Exception e) {
                Response resp = new Response();
                resp.setException(new SoaException(45345, "server handler error", e));
                session.write((Object)GsonUtil.toJson(resp));
                if (BizException.class.isInstance(e)) break block3;
                Log.printStack(e);
            }
        }
    }
}

