/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.yx.conf.AppInfo;
import org.yx.log.Log;
import org.yx.rpc.codec.SumkCodecFactory;
import org.yx.rpc.server.RequestHandler;
import org.yx.rpc.server.ServerHandler;

public class ServerListener
implements Runnable {
    private Logger logger = Log.get(this.getClass());
    private int port;
    private String host = null;
    private IoHandler handler;
    private boolean useExcutor = true;
    private int acceptors = 0;
    private SocketAcceptor acceptor;

    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    public void setUseExcutor(boolean useExcutor) {
        this.useExcutor = useExcutor;
    }

    public ServerListener(String host, int port, List<RequestHandler> handlers) {
        this.port = port;
        this.host = host;
        this.handler = new ServerHandler(handlers);
    }

    public ServerListener(int port, List<RequestHandler> handlers) {
        this.port = port;
        this.handler = new ServerHandler(handlers);
    }

    @Override
    public void run() {
        try {
            this.acceptor = this.acceptors > 0 ? new NioSocketAcceptor(this.acceptors) : new NioSocketAcceptor();
            this.acceptor.setReuseAddress(AppInfo.getBoolean("soa.port.reuse", false));
            DefaultIoFilterChainBuilder chain = this.acceptor.getFilterChain();
            chain.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)SumkCodecFactory.factory()));
            if (this.useExcutor) {
                chain.addLast("exec", (IoFilter)new ExecutorFilter((Executor)Executors.newCachedThreadPool()));
            }
            this.acceptor.setHandler(this.handler);
            this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, AppInfo.getInt("soa.session.idle", 300));
            if (SocketSessionConfig.class.isInstance(this.acceptor.getSessionConfig())) {
                SocketSessionConfig conf = this.acceptor.getSessionConfig();
                conf.setKeepAlive(true);
                conf.setReceiveBufferSize(100);
                conf.setSendBufferSize(8192);
            }
            InetSocketAddress addr = null;
            addr = this.host == null || this.host.trim().length() == 0 ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port);
            for (int i = 0; i < 12; ++i) {
                try {
                    this.acceptor.bind((SocketAddress)addr);
                    break;
                }
                catch (IOException e) {
                    Log.get("sumk.rpc").debug("waiting for listening to {}.{}", (Object)this.port, (Object)e.getMessage());
                    int time = AppInfo.getInt("soa.server.starting.sleep", 10000);
                    Thread.sleep(time);
                    continue;
                }
            }
            this.logger.info("rpc listening on " + addr);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
    }

    public void stop() throws IOException {
        if (this.acceptor == null) {
            return;
        }
        this.acceptor.dispose(false);
    }
}

