/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.server.start;

import java.io.IOException;
import java.util.Set;
import java.util.StringJoiner;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.Watcher;
import org.yx.bean.IOC;
import org.yx.bean.Plugin;
import org.yx.conf.AppInfo;
import org.yx.conf.Profile;
import org.yx.log.Log;
import org.yx.rpc.ActionHolder;
import org.yx.rpc.ZkClientHolder;
import org.yx.rpc.server.ReqHandlerFactorysBean;
import org.yx.rpc.server.ServerListener;
import org.yx.util.StringUtils;

public class SOAServer
implements Plugin {
    private boolean started = false;
    private final int port;
    private ServerListener server;
    private String zkUrl;
    private String path;

    public SOAServer(int port) {
        this.port = port;
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        try {
            String ip = AppInfo.get("soa.host");
            ip = AppInfo.get("soa.zk.host", ip);
            if (StringUtils.isEmpty(ip) || "0.0.0.0".equals(ip)) {
                ip = AppInfo.getIp();
            }
            this.path = "/SUMK_SOA/" + ip + ":" + this.port;
            this.zkUrl = AppInfo.getZKUrl();
            final ZkClient client = ZkClientHolder.getZkClient(this.zkUrl);
            ZkClientHolder.makeSure(client, "/SUMK_SOA");
            this.startServer(ip, this.port);
            client.delete(this.path);
            IZkStateListener stateListener = new IZkStateListener(){

                public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
                    Log.get("sumk.rpc").info("zk state changed:{}", (Object)state);
                }

                public void handleNewSession() throws Exception {
                    client.createEphemeral(SOAServer.this.path, (Object)SOAServer.this.createZkRouteData());
                }

                public void handleSessionEstablishmentError(Throwable error) throws Exception {
                    Log.get("sumk.rpc").error("SessionEstablishmentError#" + error.getMessage(), error);
                }
            };
            client.createEphemeral(this.path, (Object)this.createZkRouteData());
            client.subscribeStateChanges(stateListener);
            this.started = true;
        }
        catch (Exception e) {
            Log.printStack(e);
            System.exit(-1);
        }
    }

    private void startServer(String ip, int port) throws Exception {
        this.server = new ServerListener(ip, port, IOC.get(ReqHandlerFactorysBean.class).create());
        this.server.run();
    }

    private String createZkRouteData() {
        Set<String> methods = ActionHolder.soaSet();
        StringJoiner sj = new StringJoiner("\n");
        if (methods != null && methods.size() > 0) {
            sj.add("methods=" + String.join((CharSequence)",", methods.toArray(new String[methods.size()])));
        }
        sj.add("feature=" + Profile.featureInHex());
        sj.add("start=" + System.currentTimeMillis());
        return sj.toString();
    }

    @Override
    public synchronized void stop() {
        ZkClient client = ZkClientHolder.getZkClient(this.zkUrl);
        if (client != null) {
            client.unsubscribeAll();
            client.delete(this.path);
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (IOException e) {
                Log.printStack("rpc", e);
            }
        }
    }
}

