/*
 * Decompiled with CFR 0.152.
 */
package org.yx.rpc.server.start;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.yx.asm.AsmUtils;
import org.yx.bean.InnerIOC;
import org.yx.common.MethodInfo;
import org.yx.log.Log;
import org.yx.rpc.ActionHolder;
import org.yx.rpc.ActionInfo;
import org.yx.rpc.Soa;
import org.yx.rpc.server.start.SoaNameResolver;

class SoaFactory {
    private SoaNameResolver nameResolver = new SoaNameResolver();

    SoaFactory() {
    }

    public void resolve(Class<?> clz) throws Exception {
        Method[] methods = clz.getMethods();
        ArrayList<Method> actMethods = new ArrayList<Method>();
        for (Method m : methods) {
            if (AsmUtils.isFilted(m.getName()) || AsmUtils.notPublicOnly(m.getModifiers()) || m.getAnnotation(Soa.class) == null) continue;
            actMethods.add(m);
        }
        if (actMethods.isEmpty()) {
            return;
        }
        Object obj = InnerIOC.putClass(null, clz);
        Class<?> proxyClz = obj.getClass();
        String classFullName = clz.getName();
        for (Method m : actMethods) {
            Soa act;
            String soaName = this.nameResolver.solve(clz, m, (act = m.getAnnotation(Soa.class)).value());
            if (ActionHolder.getActionInfo(soaName) != null) {
                Log.get("sumk.rpc").error(soaName + " already existed");
                continue;
            }
            Method proxyedMethod = AsmUtils.proxyMethod(m, proxyClz);
            int argSize = m.getParameterTypes().length;
            if (argSize == 0) {
                ActionHolder.putActInfo(soaName, new ActionInfo(obj, proxyedMethod, null, null, null, act));
                continue;
            }
            MethodInfo mInfo = AsmUtils.createMethodInfo(classFullName, m);
            Class<?> argClz = AsmUtils.CreateArgPojo(classFullName, mInfo);
            ActionHolder.putActInfo(soaName, new ActionInfo(obj, proxyedMethod, argClz, mInfo.getArgNames(), m.getParameterTypes(), act));
        }
    }
}

