/*
 * Decompiled with CFR 0.152.
 */
package org.yx.sumk.batis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yx.conf.AppInfo;
import org.yx.conf.MultiResourceFactory;
import org.yx.log.Log;

public class LocalSqlXmlFactory
implements MultiResourceFactory {
    private File fileInClassPath(String uri) throws URISyntaxException, FileNotFoundException {
        URL url = this.getClass().getClassLoader().getResource(uri);
        return new File(url.toURI());
    }

    public File getParent(String dbName) throws Exception {
        String uri = AppInfo.get("sumk.db.batis.path", "classpath:batis/#");
        if ((uri = uri.trim().replace("#", dbName)).startsWith("classpath*:")) {
            return this.fileInClassPath(uri.substring("classpath*:".length()));
        }
        if (uri.startsWith("classpath:")) {
            return this.fileInClassPath(uri.substring("classpath:".length()));
        }
        return new File(uri);
    }

    @Override
    public Map<String, InputStream> openInputs(String db) throws Exception {
        HashMap<String, InputStream> map = new HashMap<String, InputStream>();
        ArrayList<File> xmlFiles = new ArrayList<File>();
        this.parseFileList(xmlFiles, this.getParent(db));
        for (File f : xmlFiles) {
            Log.get("sumk.db.batis").debug("mybatis file:{}", (Object)f.getAbsolutePath());
            map.put(f.getAbsolutePath(), new FileInputStream(f));
        }
        return map;
    }

    public void parseFileList(List<File> filelist, File parent) {
        File[] files = parent.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.parseFileList(filelist, f);
                    continue;
                }
                if (!f.getName().endsWith(".xml")) continue;
                filelist.add(f);
            }
        }
    }
}

