/*
 * Decompiled with CFR 0.152.
 */
package org.yx.sumk.batis;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.yx.db.DBType;
import org.yx.db.conn.ConnectionPool;
import org.yx.exception.SumkException;
import org.yx.sumk.batis.SqlSessionFactory;

public class ProxySession
implements SqlSession {
    public Connection getConnection() {
        throw new SumkException(8675, "getConnection not support");
    }

    protected SqlSession readSession() {
        ConnectionPool context = ConnectionPool.get();
        return SqlSessionFactory.get(context.getDbName()).session(context.connection(DBType.READ));
    }

    protected SqlSession writeSession() {
        ConnectionPool context = ConnectionPool.get();
        return SqlSessionFactory.get(context.getDbName()).session(context.connection(DBType.WRITE));
    }

    public <T> T selectOne(String statement) {
        return (T)this.readSession().selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.readSession().selectOne(statement, parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.readSession().selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.readSession().selectMap(statement, parameter, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.readSession().selectMap(statement, parameter, mapKey, rowBounds);
    }

    public <E> List<E> selectList(String statement) {
        return this.readSession().selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.readSession().selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.readSession().selectList(statement, parameter, rowBounds);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.readSession().select(statement, parameter, handler);
    }

    public void select(String statement, ResultHandler handler) {
        this.readSession().select(statement, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.readSession().select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.writeSession().insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.writeSession().insert(statement, parameter);
    }

    public int update(String statement) {
        return this.writeSession().update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.writeSession().update(statement, parameter);
    }

    public int delete(String statement) {
        return this.writeSession().delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.writeSession().delete(statement, parameter);
    }

    public void commit() {
    }

    public void commit(boolean force) {
    }

    public void rollback() {
    }

    public void rollback(boolean force) {
    }

    public List<BatchResult> flushStatements() {
        return this.writeSession().flushStatements();
    }

    public void close() {
    }

    public Configuration getConfiguration() {
        return this.writeSession().getConfiguration();
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.writeSession().getMapper(type);
    }

    public void clearCache() {
        this.writeSession().clearCache();
    }
}

