/*
 * Decompiled with CFR 0.152.
 */
package org.yx.sumk.batis;

import java.io.InputStream;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.SimpleExecutor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.managed.ManagedTransaction;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.sumk.batis.MybatisSqlXmlUtils;
import org.yx.util.Assert;

public class SqlSessionFactory {
    private static Configuration configuration;
    private static Map<String, SqlSessionFactory> factoryMap;
    private String db;

    private SqlSessionFactory(String dbName) {
        this.db = dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlSessionFactory get(String dbName) {
        try {
            Assert.hasText(dbName, "db name can not be empty");
            dbName = dbName.trim();
            SqlSessionFactory factory = factoryMap.get(dbName);
            if (factory != null) {
                return factory;
            }
            Class<SqlSessionFactory> clazz = SqlSessionFactory.class;
            synchronized (SqlSessionFactory.class) {
                factory = factoryMap.get(dbName);
                if (factory != null) {
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return factory;
                }
                factory = new SqlSessionFactory(dbName);
                factory.init();
                factoryMap.put(dbName, factory);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return factory;
            }
        }
        catch (Exception e) {
            Log.printStack(e);
            SumkException.throwException(100234325, "create factory failed");
            return null;
        }
    }

    void destroy() {
    }

    public static void reload(String dbName) throws Exception {
        Assert.hasText(dbName, "db name can not be empty");
        dbName = dbName.trim();
        SqlSessionFactory factory = factoryMap.get(dbName);
        if (factory == null) {
            return;
        }
        factory = new SqlSessionFactory(dbName);
        factory.init();
        SqlSessionFactory old = factoryMap.put(dbName, factory);
        old.destroy();
    }

    public SqlSession session(Connection conn) {
        ManagedTransaction transaction = new ManagedTransaction(conn, false);
        SimpleExecutor excutor = new SimpleExecutor(configuration, (Transaction)transaction);
        return new DefaultSqlSession(configuration, (Executor)excutor);
    }

    void init() throws Exception {
        configuration = new Configuration();
        Map<String, InputStream> sqls = MybatisSqlXmlUtils.openInputs(this.db);
        Set<Map.Entry<String, InputStream>> entries = sqls.entrySet();
        for (Map.Entry<String, InputStream> entry : entries) {
            InputStream in = entry.getValue();
            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(in, configuration, entry.getKey(), configuration.getSqlFragments());
            xmlMapperBuilder.parse();
            in.close();
        }
    }

    static {
        factoryMap = new ConcurrentHashMap<String, SqlSessionFactory>();
    }
}

