/*
 * Decompiled with CFR 0.152.
 */
package org.yx.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Date;
import org.yx.common.DateTimeTypeAdapter;
import org.yx.conf.AppInfo;
import org.yx.db.dao.Pojo;
import org.yx.log.Log;
import org.yx.util.StringUtils;

public final class GsonUtil {
    private static Gson[] gsons;
    private static volatile int index;

    public static GsonBuilder gsonBuilder(String module) {
        if (module == null || module.isEmpty()) {
            module = "sumk";
        }
        DateTimeTypeAdapter da = new DateTimeTypeAdapter();
        String format = AppInfo.get(module + ".json.date.format");
        if (StringUtils.isNotEmpty(format)) {
            da.setDateFormat(format);
        }
        GsonBuilder gb = new GsonBuilder().registerTypeAdapter(Date.class, (Object)da);
        if (AppInfo.getBoolean(module + ".json.disableHtmlEscaping", true)) {
            gb.disableHtmlEscaping();
        }
        if (AppInfo.getBoolean(module + ".json.shownull", false)) {
            gb.serializeNulls();
        }
        if (AppInfo.getBoolean(module + ".json.disableInnerClassSerialization", false)) {
            gb.disableInnerClassSerialization();
        }
        if (AppInfo.getBoolean(module + ".json.generateNonExecutableJson", false)) {
            gb.generateNonExecutableJson();
        }
        if (AppInfo.getBoolean(module + ".json.serializeSpecialFloatingPointValues", false)) {
            gb.serializeSpecialFloatingPointValues();
        }
        if (AppInfo.getBoolean(module + ".json.longSerialize2String", false)) {
            gb.setLongSerializationPolicy(LongSerializationPolicy.STRING);
        }
        if (AppInfo.getBoolean(module + ".json.prettyPrinting", false)) {
            gb.setPrettyPrinting();
        }
        return gb;
    }

    private static Gson createGson() {
        return GsonUtil.gsonBuilder(null).create();
    }

    public static Gson gson(String module) {
        return GsonUtil.gsonBuilder(module).create();
    }

    private static Gson getGson() {
        int i = ++index;
        return gsons[i & 7];
    }

    public static String toJson(Object obj) {
        return GsonUtil.getGson().toJson(obj);
    }

    public static String toJson(Object obj, Type type) {
        return GsonUtil.getGson().toJson(obj, type);
    }

    public static void toJson(Object obj, Type type, Appendable writer) {
        GsonUtil.getGson().toJson(obj, type, writer);
    }

    public static <T> T fromJson(String json, Class<T> clz) {
        return (T)GsonUtil.getGson().fromJson(json, clz);
    }

    public static <T> T fromJson(String json, Type type) {
        return (T)GsonUtil.getGson().fromJson(json, type);
    }

    public static <T> T fromJson(Reader reader, Class<T> clz) {
        return (T)GsonUtil.getGson().fromJson(reader, clz);
    }

    public static Object copyObject(Object source) {
        block4: {
            if (source == null) {
                return null;
            }
            if (Pojo.class.isInstance(source)) {
                try {
                    return ((Pojo)source).clone();
                }
                catch (CloneNotSupportedException e) {
                    if (!Log.isTraceEnable("gson")) break block4;
                    Log.printStack(e);
                }
            }
        }
        String json = GsonUtil.toJson(source);
        return GsonUtil.fromJson(json, source.getClass());
    }

    static {
        index = 0;
        gsons = new Gson[8];
        for (int i = 0; i < gsons.length; ++i) {
            GsonUtil.gsons[i] = GsonUtil.createGson();
        }
    }
}

