/*
 * Decompiled with CFR 0.152.
 */
package org.yx.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.yx.log.Log;
import org.yx.util.StringUtils;

public class SimpleBeanUtil {
    public static void setProperty(Object bean, Method m, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object v;
        if (value == null) {
            Log.get(SimpleBeanUtil.class, "setProperty").debug("{} was ignored because value is null", (Object)m.getName());
            return;
        }
        if ((value = value.trim()).isEmpty()) {
            Log.get(SimpleBeanUtil.class, "setProperty").debug("{} was ignored because value is empty", (Object)m.getName());
            return;
        }
        Class<?> ptype = m.getParameterTypes()[0];
        if (ptype == Integer.TYPE || ptype == Integer.class) {
            v = Integer.valueOf(value);
        } else if (ptype == Long.TYPE || ptype == Long.class) {
            v = Long.valueOf(value);
        } else if (ptype == Double.TYPE || ptype == Double.class) {
            v = Double.valueOf(value);
        } else if (ptype == Boolean.TYPE || ptype == Boolean.class) {
            v = "1".equals(value) || "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        } else if (ptype == String.class) {
            v = value;
        } else {
            Log.get(SimpleBeanUtil.class, "setProperty").debug("{}\u56e0\u4e3a\u7c7b\u578b\u4e0d\u652f\u6301\uff0c\u88ab\u8fc7\u6ee4\u6389", (Object)m.getName());
            return;
        }
        m.invoke(bean, v);
    }

    public static void copyProperties(Object bean, Map<String, String> map) throws Exception {
        Set<String> set = map.keySet();
        Method[] ms = bean.getClass().getMethods();
        for (String key : set) {
            Method m = SimpleBeanUtil.getMethod(ms, key);
            if (m == null) {
                Log.get(SimpleBeanUtil.class, "setProperties").debug("{}\u5728{}\u4e2d\u4e0d\u5b58\u5728", (Object)key, (Object)bean.getClass().getSimpleName());
                continue;
            }
            SimpleBeanUtil.setProperty(bean, m, map.get(key));
        }
    }

    private static Method getMethod(Method[] ms, String key) {
        String methodName = "set" + StringUtils.capitalize(key);
        for (Method m : ms) {
            if (!m.getName().equals(methodName) || m.getParameterCount() != 1) continue;
            return m;
        }
        return null;
    }
}

