/*
 * Decompiled with CFR 0.152.
 */
package org.yx.util;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public final class UUIDSeed {
    private static final char[] LETTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int LEN = LETTERS.length;
    private static Random[] RANDOMS;
    private static final int RANDOM_LENGTH = 5;
    private static int R_INDEX;
    private static final int DOUBLE_LEN;
    private static AtomicInteger current;

    private static Random getRandom() {
        Random r;
        int k = R_INDEX++;
        int index = k % 5;
        if (k < 10000) {
            return RANDOMS[index];
        }
        R_INDEX = ThreadLocalRandom.current().nextInt(5);
        UUIDSeed.RANDOMS[index] = r = new Random();
        return r;
    }

    static void fill(char[] source, int from, long number, int bytes) {
        if (number == Long.MIN_VALUE) {
            number = Long.MAX_VALUE;
        }
        if (number < 0L) {
            number = 0L - number;
        }
        int index = from + bytes - 1;
        while (number > 0L) {
            int k = (int)(number % (long)LEN);
            source[index] = LETTERS[k];
            if (index == from) {
                return;
            }
            number /= (long)LEN;
            --index;
        }
        while (index >= from) {
            source[index--] = 48;
        }
    }

    public static long toLong(String s) {
        String all = new String(LETTERS);
        long ret = 0L;
        int i = s.length() - 1;
        int k = 0;
        while (i >= 0) {
            char c = s.charAt(i);
            int v = all.indexOf(c + "");
            ret = (long)((double)ret + (double)v * Math.pow(LEN, k));
            --i;
            ++k;
        }
        return ret;
    }

    public static long getSeqTime(String sn) {
        return UUIDSeed.toLong(sn.substring(0, 8));
    }

    public static long getRandomSNTime(String sn) {
        char[] k = sn.toCharArray();
        String d = new String(new char[]{k[8], k[12], k[16], k[1], k[5], k[9], k[13], k[17]});
        return UUIDSeed.toLong(d);
    }

    public static String seq() {
        char[] ret = new char[20];
        UUIDSeed.fill(ret, 0, System.currentTimeMillis(), 8);
        UUIDSeed.fill(ret, 8, System.nanoTime(), 4);
        UUIDSeed.fill(ret, 12, ThreadLocalRandom.current().nextInt(DOUBLE_LEN), 2);
        int addNum = UUIDSeed.getRandom().nextInt(LEN) + 1;
        int next = current.addAndGet(addNum);
        if (next > 1000000000) {
            current = new AtomicInteger(next % (DOUBLE_LEN * DOUBLE_LEN) + DOUBLE_LEN);
        }
        UUIDSeed.fill(ret, 14, next, 4);
        UUIDSeed.fill(ret, 18, addNum, 1);
        UUIDSeed.fill(ret, 19, UUIDSeed.getRandom().nextInt(LEN), 1);
        return new String(ret);
    }

    public static String random() {
        char[] ret = new char[20];
        UUIDSeed.fill(ret, 0, ThreadLocalRandom.current().nextInt(DOUBLE_LEN), 2);
        UUIDSeed.fill(ret, 2, System.currentTimeMillis(), 8);
        UUIDSeed.fill(ret, 10, System.nanoTime(), 4);
        int addNum = UUIDSeed.getRandom().nextInt(LEN) + 1;
        int next = current.addAndGet(addNum);
        if (next > 1000000000) {
            current = new AtomicInteger(next % (DOUBLE_LEN * DOUBLE_LEN) + DOUBLE_LEN);
        }
        UUIDSeed.fill(ret, 14, next, 4);
        UUIDSeed.fill(ret, 18, addNum, 1);
        UUIDSeed.fill(ret, 19, UUIDSeed.getRandom().nextInt(LEN), 1);
        return UUIDSeed.reOrder(ret);
    }

    private static String reOrder(char[] cs) {
        char[] temp = new char[cs.length];
        int len = cs.length / 2;
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < len; ++i) {
                temp[i * 2] = cs[i];
                temp[2 * i + 1] = cs[i + len];
            }
            cs = temp;
            temp = new char[cs.length];
        }
        return new String(cs);
    }

    public static String parse(long number, int bytes) {
        if (number == Long.MIN_VALUE) {
            number = Long.MAX_VALUE;
        }
        if (number < 0L) {
            number = 0L - number;
        }
        String ret = "";
        while (number > 0L) {
            int k = (int)(number % (long)LEN);
            ret = LETTERS[k] + ret;
            number /= (long)LEN;
        }
        while (ret.length() < bytes) {
            ret = "0" + ret;
        }
        if (ret.length() > bytes) {
            return ret.substring(ret.length() - bytes, ret.length());
        }
        return ret;
    }

    static {
        R_INDEX = 0;
        RANDOMS = new Random[5];
        for (int i = 0; i < 5; ++i) {
            UUIDSeed.RANDOMS[i] = new Random();
        }
        DOUBLE_LEN = LEN * LEN;
        current = new AtomicInteger(6538);
    }
}

