/*
 * Decompiled with CFR 0.152.
 */
package org.yx.util.lock;

import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.yx.conf.AppInfo;
import org.yx.log.Log;
import org.yx.util.Assert;
import org.yx.util.UUIDSeed;
import org.yx.util.lock.Key;
import org.yx.util.lock.SLock;

public final class Lock
implements Key {
    static Logger logger = Log.get("sumk.lock");
    static final String sha = "fc8341f94e518c9868148c2b8fc7cef25ec6fa85";
    private String id;
    String value;
    int maxLockTime;
    int intervalTime;

    public Lock(String keyId, String value, int maxLockTime, int intervalTime) {
        Assert.isTrue(keyId != null && (keyId = keyId.trim()).length() > 0, "lock name cannot be empty");
        Assert.isTrue(intervalTime > 1000 && maxLockTime > 0 && value != null && value.length() > 0, "lock param is not valid");
        this.id = keyId;
        this.value = value;
        this.maxLockTime = maxLockTime;
        this.intervalTime = intervalTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public static Lock create(String name, int maxLockTime, int intervalTime) {
        return new Lock(name, UUIDSeed.seq(), maxLockTime, intervalTime);
    }

    public static Lock create(String name) {
        return Lock.create(name, AppInfo.getInt("sumk.lock.maxLockTime", 300));
    }

    public static Lock create(String name, int maxLockTime) {
        return Lock.create(name, maxLockTime, AppInfo.getInt("sumk.lock.intervalTime", 10000000));
    }

    boolean tryLock() {
        String ret = SLock.redis(this.id).set(this.id, this.value, "NX", "EX", this.maxLockTime);
        if (ret == null) {
            return false;
        }
        return (ret = ret.toUpperCase()).equals("OK") || ret.equals("1");
    }

    Lock lock(long maxWaitTime) {
        long begin = System.currentTimeMillis();
        while (System.currentTimeMillis() - begin < maxWaitTime) {
            if (this.tryLock()) {
                return this;
            }
            logger.debug("locked failed: {}={}", (Object)this.id, (Object)this.value);
            LockSupport.parkNanos(this.intervalTime);
        }
        return null;
    }

    void unlock() {
        SLock.redis(this.id).evalsha(sha, 1, this.id, this.value);
        logger.debug("unlock: {}={}", (Object)this.id, (Object)this.value);
    }

    @Override
    public void close() {
        SLock.unlock(this);
    }
}

